/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RestartPolicy;
import io.fabric8.maven.docker.config.RunVolumeConfiguration;
import io.fabric8.maven.docker.config.UlimitConfig;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.util.DeepCopy;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.annotations.Parameter;

public class RunImageConfiguration
implements Serializable {
    static final RunImageConfiguration DEFAULT = new RunImageConfiguration();
    @Parameter
    private Map<String, String> env;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private String envPropertyFile;
    @Parameter
    private Arguments cmd;
    @Parameter
    private String domainname;
    @Parameter
    private List<String> dependsOn;
    @Parameter
    private Arguments entrypoint;
    @Parameter
    private String hostname;
    @Parameter
    private String user;
    @Parameter
    private String workingDir;
    private Long shmSize;
    @Parameter
    private Long memory;
    @Parameter
    private Long memorySwap;
    @Parameter
    private String portPropertyFile;
    @Parameter
    private String net;
    @Parameter
    private NetworkConfig network;
    @Parameter
    private List<String> dns;
    @Parameter
    private List<String> dnsSearch;
    @Parameter
    private List<String> capAdd;
    @Parameter
    private List<String> capDrop;
    @Parameter
    private List<String> securityOpts;
    @Parameter
    private Boolean privileged;
    @Parameter
    private List<String> extraHosts;
    @Parameter
    private Long cpuShares;
    @Parameter
    private Long cpus;
    @Parameter
    private String cpuSet;
    @Parameter
    private List<String> ports;
    @Deprecated
    @Parameter
    private NamingStrategy namingStrategy;
    @Parameter
    private String containerNamePattern;
    @Parameter
    private String exposedPropertyKey;
    @Parameter
    private RunVolumeConfiguration volumes;
    @Parameter
    private List<String> links;
    @Parameter
    private WaitConfiguration wait;
    @Parameter
    private List<String> tmpfs;
    @Parameter
    private LogConfiguration log;
    @Parameter
    private RestartPolicy restartPolicy;
    @Parameter
    private List<UlimitConfig> ulimits;
    @Parameter
    private Boolean skip;
    @Parameter
    private String imagePullPolicy;

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public String initAndValidate() {
        NetworkConfig config;
        if (this.entrypoint != null) {
            this.entrypoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
        if ((config = this.getNetworkingConfig()) != null && config.isCustomNetwork()) {
            return "1.21";
        }
        return null;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getEnvPropertyFile() {
        return this.envPropertyFile;
    }

    public Arguments getEntrypoint() {
        return this.entrypoint;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomainname() {
        return this.domainname;
    }

    @Nonnull
    public List<String> getDependsOn() {
        return EnvUtil.splitAtCommasAndTrim(this.dependsOn);
    }

    public String getUser() {
        return this.user;
    }

    public Long getShmSize() {
        return this.shmSize;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Long getMemorySwap() {
        return this.memorySwap;
    }

    public Long getCpuShares() {
        return this.cpuShares;
    }

    public Long getCpus() {
        return this.cpus;
    }

    public String getCpuSet() {
        return this.cpuSet;
    }

    @Nonnull
    public List<String> getPorts() {
        return EnvUtil.removeEmptyEntries(this.ports);
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    public String getPortPropertyFile() {
        return this.portPropertyFile;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public WaitConfiguration getWaitConfiguration() {
        return this.wait;
    }

    public LogConfiguration getLogConfiguration() {
        return this.log;
    }

    public List<String> getCapAdd() {
        return this.capAdd;
    }

    public List<String> getCapDrop() {
        return this.capDrop;
    }

    public List<String> getSecurityOpts() {
        return this.securityOpts;
    }

    public List<String> getDns() {
        return this.dns;
    }

    @Deprecated
    public String getNetRaw() {
        return this.net;
    }

    public NetworkConfig getNetworkingConfig() {
        if (this.network != null) {
            return this.network;
        }
        if (this.net != null) {
            return new NetworkConfig(this.net);
        }
        return new NetworkConfig();
    }

    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    public RunVolumeConfiguration getVolumeConfiguration() {
        return this.volumes;
    }

    @Nonnull
    public List<String> getLinks() {
        return EnvUtil.splitAtCommasAndTrim(this.links);
    }

    public List<UlimitConfig> getUlimits() {
        return this.ulimits;
    }

    public List<String> getTmpfs() {
        return this.tmpfs;
    }

    public String getExposedPropertyKey() {
        return this.exposedPropertyKey;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy == null ? RestartPolicy.DEFAULT : this.restartPolicy;
    }

    public RestartPolicy getRestartPolicyRaw() {
        return this.restartPolicy;
    }

    public boolean skip() {
        return this.skip != null ? this.skip : false;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getContainerNamePattern() {
        return this.containerNamePattern;
    }

    @Deprecated
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public static class Builder {
        private RunImageConfiguration config;

        public Builder(RunImageConfiguration config) {
            this.config = config == null ? new RunImageConfiguration() : DeepCopy.copy(config);
        }

        public Builder() {
            this(null);
        }

        public Builder env(Map<String, String> env) {
            this.config.env = env;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.config.labels = labels;
            return this;
        }

        public Builder envPropertyFile(String envPropertyFile) {
            this.config.envPropertyFile = envPropertyFile;
            return this;
        }

        public Builder cmd(String cmd) {
            if (cmd != null) {
                this.config.cmd = new Arguments(cmd);
            }
            return this;
        }

        public Builder cmd(Arguments args) {
            this.config.cmd = args;
            return this;
        }

        public Builder domainname(String domainname) {
            this.config.domainname = domainname;
            return this;
        }

        public Builder entrypoint(Arguments args) {
            this.config.entrypoint = args;
            return this;
        }

        public Builder hostname(String hostname) {
            this.config.hostname = hostname;
            return this;
        }

        public Builder portPropertyFile(String portPropertyFile) {
            this.config.portPropertyFile = portPropertyFile;
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.config.workingDir = workingDir;
            return this;
        }

        public Builder user(String user) {
            this.config.user = user;
            return this;
        }

        public Builder shmSize(Long shmSize) {
            this.config.shmSize = shmSize;
            return this;
        }

        public Builder memory(Long memory) {
            this.config.memory = memory;
            return this;
        }

        public Builder memorySwap(Long memorySwap) {
            this.config.memorySwap = memorySwap;
            return this;
        }

        public Builder capAdd(List<String> capAdd) {
            this.config.capAdd = capAdd;
            return this;
        }

        public Builder capDrop(List<String> capDrop) {
            this.config.capDrop = capDrop;
            return this;
        }

        public Builder securityOpts(List<String> securityOpts) {
            this.config.securityOpts = securityOpts;
            return this;
        }

        public Builder net(String net) {
            this.config.net = net;
            return this;
        }

        public Builder network(NetworkConfig networkConfig) {
            this.config.network = networkConfig;
            return this;
        }

        public Builder dependsOn(List<String> dependsOn) {
            this.config.dependsOn = dependsOn;
            return this;
        }

        public Builder dns(List<String> dns) {
            this.config.dns = dns;
            return this;
        }

        public Builder dnsSearch(List<String> dnsSearch) {
            this.config.dnsSearch = dnsSearch;
            return this;
        }

        public Builder extraHosts(List<String> extraHosts) {
            this.config.extraHosts = extraHosts;
            return this;
        }

        public Builder ulimits(List<UlimitConfig> ulimits) {
            this.config.ulimits = ulimits;
            return this;
        }

        public Builder ports(List<String> ports) {
            this.config.ports = ports;
            return this;
        }

        public Builder volumes(RunVolumeConfiguration volumes) {
            this.config.volumes = volumes;
            return this;
        }

        public Builder links(List<String> links) {
            this.config.links = links;
            return this;
        }

        public Builder tmpfs(List<String> tmpfs) {
            this.config.tmpfs = tmpfs;
            return this;
        }

        public Builder wait(WaitConfiguration wait) {
            this.config.wait = wait;
            return this;
        }

        public Builder log(LogConfiguration log) {
            this.config.log = log;
            return this;
        }

        public Builder cpuShares(Long cpuShares) {
            this.config.cpuShares = cpuShares;
            return this;
        }

        public Builder cpus(Long cpus) {
            this.config.cpus = cpus;
            return this;
        }

        public Builder cpuSet(String cpuSet) {
            this.config.cpuSet = cpuSet;
            return this;
        }

        public Builder containerNamePattern(String pattern) {
            this.config.containerNamePattern = pattern;
            return this;
        }

        @Deprecated
        public Builder namingStrategy(String namingStrategy) {
            this.config.namingStrategy = namingStrategy == null ? NamingStrategy.none : NamingStrategy.valueOf(namingStrategy.toLowerCase());
            return this;
        }

        @Deprecated
        public Builder namingStrategy(NamingStrategy namingStrategy) {
            this.config.namingStrategy = namingStrategy;
            return this;
        }

        public Builder exposedPropertyKey(String key) {
            this.config.exposedPropertyKey = key;
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.config.privileged = privileged;
            return this;
        }

        public Builder restartPolicy(RestartPolicy restartPolicy) {
            this.config.restartPolicy = restartPolicy;
            return this;
        }

        public Builder skip(Boolean skip) {
            this.config.skip = skip;
            return this;
        }

        public Builder imagePullPolicy(String imagePullPolicy) {
            if (imagePullPolicy != null) {
                this.config.imagePullPolicy = imagePullPolicy;
            }
            return this;
        }

        public RunImageConfiguration build() {
            return this.config;
        }
    }

    @Deprecated
    public static enum NamingStrategy {
        none,
        alias;

    }
}

