/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.AssemblyMode;
import java.io.Serializable;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugins.annotations.Parameter;

public class AssemblyConfiguration
implements Serializable {
    @Deprecated
    private String basedir;
    @Parameter
    private String targetDir;
    @Parameter
    private String name = "maven";
    @Parameter
    private String descriptor;
    @Parameter
    private Assembly inline;
    @Parameter
    private String descriptorRef;
    @Deprecated
    @Parameter
    private String dockerFileDir;
    @Deprecated
    private Boolean exportBasedir;
    @Parameter
    private Boolean exportTargetDir;
    @Parameter
    private Boolean ignorePermissions;
    @Parameter
    private AssemblyMode mode;
    @Parameter
    private String user;
    @Parameter
    private String tarLongFileMode;
    private PermissionMode permissions;

    @Deprecated
    public Boolean getIgnorePermissions() {
        return this.ignorePermissions;
    }

    public Boolean getExportTargetDir() {
        return this.exportTargetDir;
    }

    public Boolean exportTargetDir() {
        if (this.exportTargetDir != null) {
            return this.exportTargetDir;
        }
        if (this.exportBasedir != null) {
            return this.exportBasedir;
        }
        return null;
    }

    public String getTargetDir() {
        if (this.targetDir != null) {
            return this.targetDir;
        }
        if (this.basedir != null) {
            return this.basedir;
        }
        return "/" + this.getName();
    }

    public Assembly getInline() {
        return this.inline;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getDescriptorRef() {
        return this.descriptorRef;
    }

    public String getDockerFileDir() {
        return this.dockerFileDir;
    }

    public String getUser() {
        return this.user;
    }

    public AssemblyMode getMode() {
        return this.mode != null ? this.mode : AssemblyMode.dir;
    }

    public String getModeRaw() {
        return this.mode != null ? this.mode.name() : null;
    }

    public String getTarLongFileMode() {
        return this.tarLongFileMode;
    }

    public Boolean isIgnorePermissions() {
        if (this.permissions != null) {
            return this.permissions == PermissionMode.ignore;
        }
        return this.ignorePermissions != null ? this.ignorePermissions : Boolean.FALSE;
    }

    public PermissionMode getPermissions() {
        return this.permissions != null ? this.permissions : PermissionMode.keep;
    }

    public String getPermissionsRaw() {
        return this.permissions != null ? this.permissions.name() : null;
    }

    public String getName() {
        return this.name;
    }

    public static enum PermissionMode {
        auto,
        exec,
        keep,
        ignore;

    }

    public static class Builder {
        private final AssemblyConfiguration config = new AssemblyConfiguration();
        private boolean isEmpty = true;

        public AssemblyConfiguration build() {
            return this.isEmpty ? null : this.config;
        }

        public Builder targetDir(String targetDir) {
            this.config.targetDir = this.set(targetDir);
            return this;
        }

        public Builder assemblyDef(Assembly descriptor) {
            this.config.inline = this.set(descriptor);
            return this;
        }

        public Builder descriptor(String descriptorFile) {
            this.config.descriptor = this.set(descriptorFile);
            return this;
        }

        public Builder descriptorRef(String descriptorRef) {
            this.config.descriptorRef = this.set(descriptorRef);
            return this;
        }

        public Builder dockerFileDir(String dockerFileDir) {
            this.config.dockerFileDir = this.set(dockerFileDir);
            return this;
        }

        public Builder exportBasedir(Boolean export) {
            this.config.exportBasedir = this.set(export);
            return this;
        }

        @Deprecated
        public Builder ignorePermissions(Boolean ignorePermissions) {
            this.config.ignorePermissions = this.set(ignorePermissions);
            return this;
        }

        public Builder permissions(String permissions) {
            if (permissions != null) {
                this.config.permissions = PermissionMode.valueOf(permissions.toLowerCase());
            }
            return this;
        }

        public Builder user(String user) {
            this.config.user = this.set(user);
            return this;
        }

        public Builder mode(String mode) {
            if (mode != null) {
                this.config.mode = AssemblyMode.valueOf(mode.toLowerCase());
                this.isEmpty = false;
            }
            return this;
        }

        public Builder tarLongFileMode(String tarLongFileMode) {
            this.config.tarLongFileMode = this.set(tarLongFileMode);
            return this;
        }

        private <T> T set(T prop) {
            if (prop != null) {
                this.isEmpty = false;
            }
            return prop;
        }
    }
}

