/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import io.fabric8.maven.docker.assembly.ArchiverCustomizer;
import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.StringUtils;

class AllFilesExecCustomizer
implements ArchiverCustomizer {
    private Logger log;

    AllFilesExecCustomizer(Logger logger) {
        this.log = logger;
    }

    @Override
    public TarArchiver customize(TarArchiver archiver) throws IOException {
        this.log.warn("/--------------------- SECURITY WARNING ---------------------\\", new Object[0]);
        this.log.warn("|You are building a Docker image with normalized permissions.|", new Object[0]);
        this.log.warn("|All files and directories added to build context will have  |", new Object[0]);
        this.log.warn("|'-rwxr-xr-x' permissions. It is recommended to double check |", new Object[0]);
        this.log.warn("|and reset permissions for sensitive files and directories.  |", new Object[0]);
        this.log.warn("\\------------------------------------------------------------/", new Object[0]);
        TarArchiver newArchiver = new TarArchiver();
        newArchiver.setDestFile(archiver.getDestFile());
        newArchiver.setLongfile(TarLongFileMode.posix);
        ResourceIterator resources = archiver.getResources();
        while (resources.hasNext()) {
            int mode;
            ArchiveEntry ae = resources.next();
            String fileName = ae.getName();
            PlexusIoResource resource = ae.getResource();
            String name = StringUtils.replace((String)fileName, (char)File.separatorChar, (char)'/');
            int newMode = mode = ae.getMode() & 0x1FF;
            newMode &= 0x1ED;
            if ((newMode |= 0x49) != mode) {
                this.log.debug("Changing permissions of '%s' from %o to %o.", name, mode, newMode);
            }
            newArchiver.addResource(resource, name, newMode);
        }
        archiver = newArchiver;
        return archiver;
    }
}

