/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ExecConfig;
import io.fabric8.kubernetes.api.model.ExecEnvVar;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(KubeConfigUtils.class);
    private static final String KUBERNETES_CONFIG_CONTEXT_FILE_KEY = "KUBERNETES_CONFIG_CONTEXT_FILE_KEY";
    private static final String KUBERNETES_CONFIG_CLUSTER_FILE_KEY = "KUBERNETES_CONFIG_CLUSTER_FILE_KEY";
    private static final String KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY = "KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY";
    private static final String ACCESS_TOKEN = "access-token";
    private static final String ID_TOKEN = "id-token";

    private KubeConfigUtils() {
    }

    public static io.fabric8.kubernetes.api.model.Config parseConfig(File kubeconfig) {
        io.fabric8.kubernetes.api.model.Config config;
        block12: {
            if (kubeconfig == null) {
                throw new KubernetesClientException("kubeconfig (File) cannot be null");
            }
            InputStream fis = Files.newInputStream(kubeconfig.toPath(), new OpenOption[0]);
            try {
                io.fabric8.kubernetes.api.model.Config ret = Serialization.unmarshal(fis, io.fabric8.kubernetes.api.model.Config.class);
                if (ret.getContexts() != null) {
                    ret.getContexts().forEach(ctx -> ctx.getAdditionalProperties().put(KUBERNETES_CONFIG_CONTEXT_FILE_KEY, kubeconfig));
                }
                if (ret.getClusters() != null) {
                    ret.getClusters().forEach(cluster -> cluster.getAdditionalProperties().put(KUBERNETES_CONFIG_CLUSTER_FILE_KEY, kubeconfig));
                }
                if (ret.getUsers() != null) {
                    ret.getUsers().forEach(user -> user.getAdditionalProperties().put(KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY, kubeconfig));
                }
                config = ret;
                if (fis == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(String.valueOf(kubeconfig) + " (File) is not a parseable Kubernetes Config", (Throwable)e);
                }
            }
            fis.close();
        }
        return config;
    }

    public static io.fabric8.kubernetes.api.model.Config parseConfigFromString(String contents) {
        return Serialization.unmarshal(contents, io.fabric8.kubernetes.api.model.Config.class);
    }

    public static void persistKubeConfigIntoFile(io.fabric8.kubernetes.api.model.Config kubeconfig, File kubeConfigPath) throws IOException {
        if (kubeconfig.getContexts() != null) {
            kubeconfig.getContexts().forEach(c -> KubeConfigUtils.removeAdditionalProperties(c::getAdditionalProperties));
        }
        if (kubeconfig.getClusters() != null) {
            kubeconfig.getClusters().forEach(c -> KubeConfigUtils.removeAdditionalProperties(c::getAdditionalProperties));
        }
        if (kubeconfig.getUsers() != null) {
            kubeconfig.getUsers().forEach(c -> KubeConfigUtils.removeAdditionalProperties(c::getAdditionalProperties));
        }
        Files.writeString(kubeConfigPath.toPath(), (CharSequence)Serialization.asYaml(kubeconfig), new OpenOption[0]);
    }

    public static File getFileWithNamedContext(NamedContext namedContext) {
        return KubeConfigUtils.getFile(namedContext != null ? namedContext::getAdditionalProperties : null, KUBERNETES_CONFIG_CONTEXT_FILE_KEY);
    }

    public static File getFileWithNamedCluster(NamedContext namedContext) {
        return KubeConfigUtils.getFile(namedContext != null ? namedContext::getAdditionalProperties : null, KUBERNETES_CONFIG_CLUSTER_FILE_KEY);
    }

    public static File getFileWithNamedAuthInfo(NamedContext namedContext) {
        return KubeConfigUtils.getFile(namedContext != null ? namedContext::getAdditionalProperties : null, KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY);
    }

    private static File getFileWithNamedCluster(NamedCluster namedCluster) {
        return KubeConfigUtils.getFile(namedCluster != null ? namedCluster::getAdditionalProperties : null, KUBERNETES_CONFIG_CLUSTER_FILE_KEY);
    }

    private static File getFileWithNamedAuthInfo(NamedAuthInfo namedAuthInfo) {
        return KubeConfigUtils.getFile(namedAuthInfo != null ? namedAuthInfo::getAdditionalProperties : null, KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY);
    }

    private static File getFile(Supplier<Map<String, Object>> provider, String key) {
        return provider != null && provider.get() != null && provider.get().get(key) instanceof File ? (File)provider.get().get(key) : null;
    }

    public static void merge(Config clientConfig, String context, io.fabric8.kubernetes.api.model.Config ... kubeconfigs) {
        Map<String, NamedAuthInfo> mergedUsers;
        NamedAuthInfo currentNamedAuthInfo;
        Map<String, NamedContext> mergedContexts = KubeConfigUtils.mergeContexts(clientConfig, kubeconfigs);
        clientConfig.setContexts(new ArrayList<NamedContext>(mergedContexts.values()));
        NamedContext currentContext = null;
        for (String contextName : KubeConfigUtils.contextPreference(context, kubeconfigs)) {
            if (!mergedContexts.containsKey(contextName)) continue;
            currentContext = mergedContexts.get(contextName);
            break;
        }
        if (currentContext == null || currentContext.getContext() == null) {
            return;
        }
        clientConfig.setCurrentContext(currentContext);
        clientConfig.setNamespace(currentContext.getContext().getNamespace());
        Map<String, NamedCluster> mergedClusters = KubeConfigUtils.mergeClusters(kubeconfigs);
        NamedCluster currentNamedCluster = mergedClusters.get(currentContext.getContext().getCluster());
        if (currentNamedCluster != null) {
            File configFile = KubeConfigUtils.getFileWithNamedCluster(currentNamedCluster);
            currentContext.setAdditionalProperty(KUBERNETES_CONFIG_CLUSTER_FILE_KEY, configFile);
            Cluster currentCluster = currentNamedCluster.getCluster();
            clientConfig.setMasterUrl(currentCluster.getServer());
            clientConfig.setTrustCerts(Objects.equals(currentCluster.getInsecureSkipTlsVerify(), true));
            clientConfig.setDisableHostnameVerification(Objects.equals(currentCluster.getInsecureSkipTlsVerify(), true));
            String caCertFile = configFile != null ? KubeConfigUtils.absolutify(configFile, currentCluster.getCertificateAuthority()) : currentCluster.getCertificateAuthority();
            clientConfig.setCaCertFile(caCertFile);
            clientConfig.setCaCertData(currentCluster.getCertificateAuthorityData());
            String proxyUrl = currentCluster.getProxyUrl();
            if (Utils.isNotNullOrEmpty(proxyUrl)) {
                if (proxyUrl.startsWith("socks5://") && clientConfig.getMasterUrl().startsWith("https://")) {
                    clientConfig.setHttpsProxy(proxyUrl);
                } else if (proxyUrl.startsWith("socks5://")) {
                    clientConfig.setHttpProxy(proxyUrl);
                } else if (proxyUrl.startsWith("http://")) {
                    clientConfig.setHttpProxy(proxyUrl);
                } else if (proxyUrl.startsWith("https://")) {
                    clientConfig.setHttpsProxy(proxyUrl);
                }
            }
        }
        if ((currentNamedAuthInfo = (mergedUsers = KubeConfigUtils.mergeUsers(kubeconfigs)).get(currentContext.getContext().getUser())) != null) {
            File configFile = KubeConfigUtils.getFileWithNamedAuthInfo(currentNamedAuthInfo);
            currentContext.setAdditionalProperty(KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY, configFile);
            AuthInfo currentAuthInfo = currentNamedAuthInfo.getUser();
            String clientCertFile = currentAuthInfo.getClientCertificate();
            String clientKeyFile = currentAuthInfo.getClientKey();
            if (configFile != null) {
                clientCertFile = KubeConfigUtils.absolutify(configFile, currentAuthInfo.getClientCertificate());
                clientKeyFile = KubeConfigUtils.absolutify(configFile, currentAuthInfo.getClientKey());
            }
            clientConfig.setClientCertFile(clientCertFile);
            clientConfig.setClientCertData(currentAuthInfo.getClientCertificateData());
            clientConfig.setClientKeyFile(clientKeyFile);
            clientConfig.setClientKeyData(currentAuthInfo.getClientKeyData());
            clientConfig.setClientKeyAlgo(Config.getKeyAlgorithm(clientConfig.getClientKeyFile(), clientConfig.getClientKeyData()));
            clientConfig.setAutoOAuthToken(currentAuthInfo.getToken());
            clientConfig.setUsername(currentAuthInfo.getUsername());
            clientConfig.setPassword(currentAuthInfo.getPassword());
            if (Utils.isNullOrEmpty(clientConfig.getAutoOAuthToken()) && currentAuthInfo.getAuthProvider() != null) {
                KubeConfigUtils.mergeKubeConfigAuthProviderConfig(clientConfig, currentAuthInfo);
            } else if (clientConfig.getOauthTokenProvider() == null) {
                KubeConfigUtils.mergeKubeConfigExecCredential(clientConfig, currentAuthInfo.getExec(), configFile);
            }
        }
    }

    private static Map<String, NamedContext> mergeContexts(Config config, io.fabric8.kubernetes.api.model.Config ... kubeconfigs) {
        HashMap<String, NamedContext> mergedContexts = new HashMap<String, NamedContext>();
        for (int i = kubeconfigs.length - 1; i >= 0; --i) {
            if (kubeconfigs[i].getContexts() == null) continue;
            for (NamedContext ctx : kubeconfigs[i].getContexts()) {
                if (ctx.getContext() == null) continue;
                mergedContexts.put(ctx.getName(), ctx);
            }
        }
        if (config.getContexts() != null) {
            for (NamedContext ctx : config.getContexts()) {
                mergedContexts.put(ctx.getName(), ctx);
            }
        }
        return mergedContexts;
    }

    private static Map<String, NamedCluster> mergeClusters(io.fabric8.kubernetes.api.model.Config ... kubeconfigs) {
        HashMap<String, NamedCluster> mergedClusters = new HashMap<String, NamedCluster>();
        for (int i = kubeconfigs.length - 1; i >= 0; --i) {
            if (kubeconfigs[i].getClusters() == null) continue;
            for (NamedCluster cluster : kubeconfigs[i].getClusters()) {
                if (cluster.getCluster() == null) continue;
                mergedClusters.put(cluster.getName(), cluster);
            }
        }
        return mergedClusters;
    }

    private static Map<String, NamedAuthInfo> mergeUsers(io.fabric8.kubernetes.api.model.Config ... kubeconfigs) {
        HashMap<String, NamedAuthInfo> mergedUsers = new HashMap<String, NamedAuthInfo>();
        for (int i = kubeconfigs.length - 1; i >= 0; --i) {
            if (kubeconfigs[i].getUsers() == null) continue;
            for (NamedAuthInfo user : kubeconfigs[i].getUsers()) {
                if (user.getUser() == null) continue;
                mergedUsers.put(user.getName(), user);
            }
        }
        return mergedUsers;
    }

    private static List<String> contextPreference(String context, io.fabric8.kubernetes.api.model.Config ... kubeconfigs) {
        ArrayList<String> contextPreference = new ArrayList<String>();
        if (Utils.isNotNullOrEmpty(context)) {
            contextPreference.add(context);
        }
        for (io.fabric8.kubernetes.api.model.Config kubeconfig : kubeconfigs) {
            if (!Utils.isNotNullOrEmpty(kubeconfig.getCurrentContext())) continue;
            contextPreference.add(kubeconfig.getCurrentContext());
        }
        return contextPreference;
    }

    private static void mergeKubeConfigAuthProviderConfig(Config config, AuthInfo currentAuthInfo) {
        if (currentAuthInfo.getAuthProvider().getConfig() != null) {
            config.setAuthProvider(currentAuthInfo.getAuthProvider());
            if (!Utils.isNullOrEmpty(currentAuthInfo.getAuthProvider().getConfig().get(ACCESS_TOKEN))) {
                config.setAutoOAuthToken(currentAuthInfo.getAuthProvider().getConfig().get(ACCESS_TOKEN));
            } else if (!Utils.isNullOrEmpty(currentAuthInfo.getAuthProvider().getConfig().get(ID_TOKEN))) {
                config.setAutoOAuthToken(currentAuthInfo.getAuthProvider().getConfig().get(ID_TOKEN));
            }
        }
    }

    private static void mergeKubeConfigExecCredential(Config config, ExecConfig exec, File configFile) {
        Config.ExecCredential ec;
        if (exec != null && (ec = KubeConfigUtils.getExecCredentialFromExecConfig(exec, configFile)) != null && ec.status != null) {
            if (ec.status.token != null) {
                config.setAutoOAuthToken(ec.status.token);
            } else if (Utils.isNotNullOrEmpty(ec.status.clientCertificateData) && Utils.isNotNullOrEmpty(ec.status.clientKeyData)) {
                config.setClientCertData(ec.status.clientCertificateData);
                config.setClientKeyData(ec.status.clientKeyData);
            } else {
                logger.warn("No token or certificate returned");
            }
        }
    }

    protected static Config.ExecCredential getExecCredentialFromExecConfig(ExecConfig exec, File configFile) {
        String output;
        String apiVersion = exec.getApiVersion();
        List<ExecEnvVar> env = exec.getEnv();
        ProcessBuilder pb = new ProcessBuilder(KubeConfigUtils.getAuthenticatorCommandFromExecConfig(exec, configFile, Utils.getSystemPathVariable()));
        pb.redirectErrorStream(true);
        if (env != null) {
            Map<String, String> environment = pb.environment();
            env.forEach(var -> environment.put(var.getName(), var.getValue()));
        }
        try {
            Process p = pb.start();
            try (InputStream is = p.getInputStream();){
                output = IOHelpers.readFully(is);
            }
            if (p.waitFor() != 0) {
                logger.warn(output);
            }
        }
        catch (IOException ex) {
            throw KubernetesClientException.launderThrowable(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ex);
        }
        try {
            Config.ExecCredential ec = Serialization.unmarshal(output, Config.ExecCredential.class);
            if (ec != null && Objects.equals(apiVersion, ec.apiVersion)) {
                return ec;
            }
            logger.warn("Wrong apiVersion {} vs. {}", (Object)(ec == null ? null : ec.apiVersion), (Object)apiVersion);
        }
        catch (Exception ex) {
            logger.warn("Error unmarshalling ExecCredential", ex);
        }
        return null;
    }

    protected static List<String> getAuthenticatorCommandFromExecConfig(ExecConfig exec, File configFile, String systemPathValue) {
        Object command = exec.getCommand();
        if (((String)command).contains(File.separator) && !((String)command).startsWith(File.separator) && configFile != null) {
            command = Paths.get(configFile.getAbsolutePath(), new String[0]).resolveSibling((String)command).normalize().toString();
        }
        ArrayList<String> argv = new ArrayList<String>(Utils.getCommandPlatformPrefix());
        command = KubeConfigUtils.findExecutable((String)command, systemPathValue);
        command = KubeConfigUtils.shellQuote((String)command);
        List<String> args = exec.getArgs();
        if (args != null && !args.isEmpty()) {
            command = (String)command + " " + args.stream().map(KubeConfigUtils::shellQuote).collect(Collectors.joining(" "));
        }
        argv.add((String)command);
        return argv;
    }

    private static String shellQuote(String value) {
        if (value.contains(" ") || value.contains("\"") || value.contains("'")) {
            return "\"" + value.replace("\"", "\\\"") + "\"";
        }
        return value;
    }

    protected static String findExecutable(String command, String pathValue) {
        for (String pathPart : pathValue.split(File.pathSeparator)) {
            File commandFile = new File(pathPart + File.separator + command);
            if (!commandFile.exists()) continue;
            return commandFile.getAbsolutePath();
        }
        return command;
    }

    private static String absolutify(File relativeTo, String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        return new File(relativeTo.getParentFile(), filename).getAbsolutePath();
    }

    private static void removeAdditionalProperties(Supplier<Map<String, Object>> provider) {
        if (provider == null) {
            return;
        }
        provider.get().remove(KUBERNETES_CONFIG_CONTEXT_FILE_KEY);
        provider.get().remove(KUBERNETES_CONFIG_CLUSTER_FILE_KEY);
        provider.get().remove(KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY);
    }
}

