/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.SundrioConfig;
import io.fabric8.kubernetes.client.SundrioConfigBuilder;
import io.fabric8.kubernetes.client.Version;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(allowGetters=true, allowSetters=true)
public class Config
extends SundrioConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    public static final String KUBERNETES_DISABLE_AUTO_CONFIG_SYSTEM_PROPERTY = "kubernetes.disable.autoConfig";
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    public static final String KUBERNETES_API_VERSION_SYSTEM_PROPERTY = "kubernetes.api.version";
    public static final String KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY = "kubernetes.trust.certificates";
    public static final String KUBERNETES_DISABLE_HOSTNAME_VERIFICATION_SYSTEM_PROPERTY = "kubernetes.disable.hostname.verification";
    public static final String KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.ca.file";
    public static final String KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.ca.data";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.file";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.data";
    public static final String KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.file";
    public static final String KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.key.data";
    public static final String KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY = "kubernetes.certs.client.key.algo";
    public static final String KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.passphrase";
    public static final String KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY = "kubernetes.auth.basic.username";
    public static final String KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY = "kubernetes.auth.basic.password";
    public static final String KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY = "kubernetes.auth.tryKubeConfig";
    public static final String KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY = "kubernetes.auth.tryServiceAccount";
    public static final String KUBERNETES_AUTH_SERVICEACCOUNT_TOKEN_FILE_SYSTEM_PROPERTY = "kubernetes.auth.serviceAccount.token";
    public static final String KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY = "kubernetes.auth.token";
    public static final String KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY = "kubernetes.watch.reconnectInterval";
    public static final String KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY = "kubernetes.watch.reconnectLimit";
    public static final String KUBERNETES_CONNECTION_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.connection.timeout";
    public static final String KUBERNETES_UPLOAD_REQUEST_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.upload.request.timeout";
    public static final String KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.request.timeout";
    public static final String KUBERNETES_REQUEST_RETRY_BACKOFFLIMIT_SYSTEM_PROPERTY = "kubernetes.request.retry.backoffLimit";
    public static final String KUBERNETES_REQUEST_RETRY_BACKOFFINTERVAL_SYSTEM_PROPERTY = "kubernetes.request.retry.backoffInterval";
    public static final String KUBERNETES_LOGGING_INTERVAL_SYSTEM_PROPERTY = "kubernetes.logging.interval";
    public static final String KUBERNETES_SCALE_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.scale.timeout";
    public static final String KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY = "kubernetes.websocket.ping.interval";
    public static final String KUBERNETES_MAX_CONCURRENT_REQUESTS = "kubernetes.max.concurrent.requests";
    public static final String KUBERNETES_MAX_CONCURRENT_REQUESTS_PER_HOST = "kubernetes.max.concurrent.requests.per.host";
    public static final String KUBERNETES_IMPERSONATE_USERNAME = "kubernetes.impersonate.username";
    public static final String KUBERNETES_IMPERSONATE_GROUP = "kubernetes.impersonate.group";
    public static final String KUBERNETES_TRUSTSTORE_PASSPHRASE_PROPERTY = "kubernetes.truststore.passphrase";
    public static final String KUBERNETES_TRUSTSTORE_FILE_PROPERTY = "kubernetes.truststore.file";
    public static final String KUBERNETES_KEYSTORE_PASSPHRASE_PROPERTY = "kubernetes.keystore.passphrase";
    public static final String KUBERNETES_KEYSTORE_FILE_PROPERTY = "kubernetes.keystore.file";
    public static final String KUBERNETES_TLS_VERSIONS = "kubernetes.tls.versions";
    public static final String KUBERNETES_TRYNAMESPACE_PATH_SYSTEM_PROPERTY = "kubernetes.tryNamespacePath";
    public static final String KUBERNETES_NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    public static final String KUBERNETES_NAMESPACE_FILE = "kubenamespace";
    public static final String KUBERNETES_NAMESPACE_SYSTEM_PROPERTY = "kubernetes.namespace";
    public static final String KUBERNETES_KUBECONFIG_FILE = "kubeconfig";
    public static final String KUBERNETES_SERVICE_HOST_PROPERTY = "KUBERNETES_SERVICE_HOST";
    public static final String KUBERNETES_SERVICE_PORT_PROPERTY = "KUBERNETES_SERVICE_PORT";
    public static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String KUBERNETES_HTTP2_DISABLE = "http2.disable";
    public static final String KUBERNETES_HTTP_PROXY = "http.proxy";
    public static final String KUBERNETES_HTTPS_PROXY = "https.proxy";
    public static final String KUBERNETES_ALL_PROXY = "all.proxy";
    public static final String KUBERNETES_NO_PROXY = "no.proxy";
    public static final String KUBERNETES_PROXY_USERNAME = "proxy.username";
    public static final String KUBERNETES_PROXY_PASSWORD = "proxy.password";
    public static final String KUBERNETES_USER_AGENT = "kubernetes.user.agent";
    public static final String DEFAULT_MASTER_URL = "https://kubernetes.default.svc";
    public static final Long DEFAULT_SCALE_TIMEOUT = 600000L;
    public static final int DEFAULT_REQUEST_TIMEOUT = 10000;
    public static final int DEFAULT_LOGGING_INTERVAL = 20000;
    public static final Long DEFAULT_WEBSOCKET_PING_INTERVAL = 30000L;
    public static final Integer DEFAULT_MAX_CONCURRENT_REQUESTS = 64;
    public static final Integer DEFAULT_MAX_CONCURRENT_REQUESTS_PER_HOST = 5;
    public static final Integer DEFAULT_REQUEST_RETRY_BACKOFFLIMIT = 10;
    public static final Integer DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL = 100;
    public static final int DEFAULT_UPLOAD_REQUEST_TIMEOUT = 120000;
    public static final String HTTP_PROTOCOL_PREFIX = "http://";
    public static final String HTTPS_PROTOCOL_PREFIX = "https://";
    public static final String SOCKS5_PROTOCOL_PREFIX = "socks5://";
    private static final int DEFAULT_WATCH_RECONNECT_INTERVAL = 1000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final String DEFAULT_CLIENT_KEY_PASSPHRASE = "changeit";
    private RequestConfig requestConfig = new RequestConfig(null, null, null, null, null, null, null, null);

    protected static boolean disableAutoConfig() {
        return Utils.getSystemPropertyOrEnvVar(KUBERNETES_DISABLE_AUTO_CONFIG_SYSTEM_PROPERTY, false);
    }

    public static Config empty() {
        return new Config(false);
    }

    public static Config autoConfigure(String context) {
        Config config = new Config(false);
        Config.autoConfigure(config, context);
        return config;
    }

    private static void autoConfigure(Config config, String context) {
        Collection<File> kubeConfigFiles = Config.findKubeConfigFiles();
        if (!kubeConfigFiles.isEmpty()) {
            io.fabric8.kubernetes.api.model.Config[] kubeconfigs = (io.fabric8.kubernetes.api.model.Config[])kubeConfigFiles.stream().map(KubeConfigUtils::parseConfig).toArray(io.fabric8.kubernetes.api.model.Config[]::new);
            KubeConfigUtils.merge(config, context, kubeconfigs);
        } else {
            Config.tryServiceAccount(config);
            Config.tryNamespaceFromPath(config);
        }
        Config.postAutoConfigure(config);
        config.setAutoConfigure(true);
    }

    private static void postAutoConfigure(Config config) {
        Config.configFromSysPropsOrEnvVars(config);
    }

    private static String ensureEndsWithSlash(String masterUrl) {
        if (!((String)masterUrl).endsWith("/")) {
            masterUrl = (String)masterUrl + "/";
        }
        return masterUrl;
    }

    private static String ensureHttps(String masterUrl, Config config) {
        if (!((String)masterUrl).toLowerCase(Locale.ROOT).startsWith(HTTP_PROTOCOL_PREFIX) && !((String)masterUrl).toLowerCase(Locale.ROOT).startsWith(HTTPS_PROTOCOL_PREFIX)) {
            masterUrl = (SSLUtils.isHttpsAvailable(config) ? HTTPS_PROTOCOL_PREFIX : HTTP_PROTOCOL_PREFIX) + (String)masterUrl;
        }
        return masterUrl;
    }

    protected Config(boolean autoConfigure) {
        this(((SundrioConfigBuilder)new SundrioConfigBuilder().withAutoConfigure(autoConfigure)).build(), true);
    }

    protected Config() {
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public Config(SundrioConfig config) {
        this(config, true);
    }

    protected Config(SundrioConfig config, Boolean shouldSetDefaultValues) {
        if (Boolean.TRUE.equals(shouldSetDefaultValues)) {
            this.setMasterUrl(DEFAULT_MASTER_URL);
            this.setApiVersion("v1");
            this.setDefaultNamespace(true);
            this.setTrustCerts(false);
            this.setDisableHostnameVerification(false);
            this.setOnlyHttpWatches(false);
            this.setHttp2Disable(false);
            this.setClientKeyAlgo("RSA");
            this.setClientKeyPassphrase(DEFAULT_CLIENT_KEY_PASSPHRASE);
            this.setWebsocketPingInterval(DEFAULT_WEBSOCKET_PING_INTERVAL);
            this.setConnectionTimeout(10000);
            this.setMaxConcurrentRequests(DEFAULT_MAX_CONCURRENT_REQUESTS);
            this.setMaxConcurrentRequestsPerHost(DEFAULT_MAX_CONCURRENT_REQUESTS_PER_HOST);
            this.setContexts(new ArrayList<NamedContext>());
            this.setWatchReconnectInterval(1000);
            this.setWatchReconnectLimit(-1);
            this.setUploadRequestTimeout(120000);
            this.setRequestRetryBackoffInterval(DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL);
            this.setRequestRetryBackoffLimit(DEFAULT_REQUEST_RETRY_BACKOFFLIMIT);
            this.setRequestTimeout(10000);
            this.setScaleTimeout(DEFAULT_SCALE_TIMEOUT);
            this.setLoggingInterval(20000);
            this.setUserAgent("fabric8-kubernetes-client/" + Version.clientVersion());
            this.setTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2});
        }
        if (Boolean.TRUE.equals(config.getAutoConfigure())) {
            Config.autoConfigure(this, null);
        }
        if (Utils.isNotNullOrEmpty(config.getApiVersion())) {
            this.setApiVersion(config.getApiVersion());
        }
        if (Utils.isNotNullOrEmpty(config.getMasterUrl())) {
            this.setMasterUrl(config.getMasterUrl());
        }
        if (Utils.isNotNullOrEmpty(config.getNamespace())) {
            this.setNamespace(config.getNamespace());
        }
        if (Boolean.TRUE.equals(config.getTrustCerts())) {
            this.setTrustCerts(true);
        }
        if (Boolean.TRUE.equals(config.getDisableHostnameVerification())) {
            this.setDisableHostnameVerification(true);
        }
        if (Utils.isNotNullOrEmpty(config.getCaCertFile())) {
            this.setCaCertFile(config.getCaCertFile());
        }
        if (Utils.isNotNullOrEmpty(config.getCaCertData())) {
            this.setCaCertData(config.getCaCertData());
        }
        if (Utils.isNotNullOrEmpty(config.getClientCertFile())) {
            this.setClientCertFile(config.getClientCertFile());
        }
        if (Utils.isNotNullOrEmpty(config.getClientCertData())) {
            this.setClientCertData(config.getClientCertData());
        }
        if (Utils.isNotNullOrEmpty(config.getClientKeyFile())) {
            this.setClientKeyFile(config.getClientKeyFile());
        }
        if (Utils.isNotNullOrEmpty(config.getClientKeyData())) {
            this.setClientKeyData(config.getClientKeyData());
        }
        if (Utils.isNotNullOrEmpty(config.getClientKeyAlgo())) {
            this.setClientKeyAlgo(config.getClientKeyAlgo());
        }
        if (Utils.isNotNullOrEmpty(config.getClientKeyPassphrase())) {
            this.setClientKeyPassphrase(config.getClientKeyPassphrase());
        }
        if (Utils.isNotNullOrEmpty(config.getUsername())) {
            this.setUsername(config.getUsername());
        }
        if (Utils.isNotNullOrEmpty(config.getPassword())) {
            this.setPassword(config.getPassword());
        }
        if (Utils.isNotNullOrEmpty(config.getOauthToken())) {
            this.setOauthToken(config.getOauthToken());
        }
        if (config.getWebsocketPingInterval() != null) {
            this.setWebsocketPingInterval(config.getWebsocketPingInterval());
        }
        if (config.getConnectionTimeout() != null) {
            this.setConnectionTimeout(config.getConnectionTimeout());
        }
        if (config.getWatchReconnectLimit() != null) {
            this.setWatchReconnectLimit(config.getWatchReconnectLimit());
        }
        if (config.getWatchReconnectInterval() != null) {
            this.setWatchReconnectInterval(config.getWatchReconnectInterval());
        }
        if (config.getRequestTimeout() != null) {
            this.setRequestTimeout(config.getRequestTimeout());
        }
        if (config.getScaleTimeout() != null) {
            this.setScaleTimeout(config.getScaleTimeout());
        }
        if (config.getLoggingInterval() != null) {
            this.setLoggingInterval(config.getLoggingInterval());
        }
        if (config.getRequestRetryBackoffLimit() != null) {
            this.setRequestRetryBackoffLimit(config.getRequestRetryBackoffLimit());
        }
        if (config.getRequestRetryBackoffInterval() != null) {
            this.setRequestRetryBackoffInterval(config.getRequestRetryBackoffInterval());
        }
        if (config.getUploadRequestTimeout() != null) {
            this.setUploadRequestTimeout(config.getUploadRequestTimeout());
        }
        if (Utils.isNotNullOrEmpty(config.getImpersonateUsername())) {
            this.setImpersonateUsername(config.getImpersonateUsername());
        }
        if (Utils.isNotNullOrEmpty(config.getImpersonateGroups())) {
            this.setImpersonateGroups(config.getImpersonateGroups());
        }
        if (Utils.isNotNullOrEmpty(config.getImpersonateExtras())) {
            this.setImpersonateExtras(config.getImpersonateExtras());
        }
        if (config.getHttp2Disable() != null) {
            this.setHttp2Disable(config.getHttp2Disable());
        }
        if (Utils.isNotNullOrEmpty(config.getHttpProxy())) {
            this.setHttpProxy(config.getHttpProxy());
        }
        if (Utils.isNotNullOrEmpty(config.getHttpsProxy())) {
            this.setHttpsProxy(config.getHttpsProxy());
        }
        if (Utils.isNotNullOrEmpty(config.getNoProxy())) {
            this.setNoProxy(config.getNoProxy());
        }
        if (Utils.isNotNullOrEmpty(config.getProxyUsername())) {
            this.setProxyUsername(config.getProxyUsername());
        }
        if (Utils.isNotNullOrEmpty(config.getProxyPassword())) {
            this.setProxyPassword(config.getProxyPassword());
        }
        if (Utils.isNotNullOrEmpty(config.getUserAgent())) {
            this.setUserAgent(config.getUserAgent());
        }
        if (config.getTlsVersions() != null && config.getTlsVersions().length > 0) {
            this.setTlsVersions(config.getTlsVersions());
        }
        if (Utils.isNotNullOrEmpty(config.getTrustStoreFile())) {
            this.setTrustStoreFile(config.getTrustStoreFile());
        }
        if (Utils.isNotNullOrEmpty(config.getTrustStorePassphrase())) {
            this.setTrustStorePassphrase(config.getTrustStorePassphrase());
        }
        if (Utils.isNotNullOrEmpty(config.getKeyStoreFile())) {
            this.setKeyStoreFile(config.getKeyStoreFile());
        }
        if (Utils.isNotNullOrEmpty(config.getKeyStorePassphrase())) {
            this.setKeyStorePassphrase(config.getKeyStorePassphrase());
        }
        if (config.getMaxConcurrentRequests() != null) {
            this.setMaxConcurrentRequests(config.getMaxConcurrentRequests());
        }
        if (config.getMaxConcurrentRequestsPerHost() != null) {
            this.setMaxConcurrentRequestsPerHost(config.getMaxConcurrentRequestsPerHost());
        }
        if (Utils.isNotNullOrEmpty(config.getAutoOAuthToken())) {
            this.setAutoOAuthToken(config.getAutoOAuthToken());
        }
        if (config.getContexts() != null && !config.getContexts().isEmpty()) {
            this.setContexts(config.getContexts());
        }
        if (Utils.isNotNull(config.getCurrentContext())) {
            this.setCurrentContext(config.getCurrentContext());
        }
        if (Utils.isNotNullOrEmpty(config.getMasterUrl())) {
            this.setMasterUrl(config.getMasterUrl());
        }
        this.setAutoConfigure(config.getAutoConfigure());
        this.setOauthTokenProvider(config.getOauthTokenProvider());
        this.setCustomHeaders(config.getCustomHeaders());
        if (config.getOnlyHttpWatches() != null) {
            this.setOnlyHttpWatches(config.getOnlyHttpWatches());
        }
        this.setAuthProvider(config.getAuthProvider());
        if (config.getAdditionalProperties() != null) {
            this.setAdditionalProperties(new LinkedHashMap<String, Object>(config.getAdditionalProperties()));
        }
        if (config.getDefaultNamespace() != null) {
            this.setDefaultNamespace(config.getDefaultNamespace());
        }
        if (config.getWatchList() != null) {
            this.setWatchList(config.getWatchList());
        }
    }

    public static void configFromSysPropsOrEnvVars(Config config) {
        String tlsVersionsVar;
        String configuredMaxConcurrentReqeustsPerHost;
        String configuredMaxConcurrentRequests;
        String configuredLoggingInterval;
        String configuredScaleTimeout;
        String configuredWatchReconnectLimit;
        String configuredWatchReconnectInterval;
        config.setTrustCerts(Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY, config.isTrustCerts()));
        config.setDisableHostnameVerification(Utils.getSystemPropertyOrEnvVar(KUBERNETES_DISABLE_HOSTNAME_VERIFICATION_SYSTEM_PROPERTY, config.isDisableHostnameVerification()));
        config.setMasterUrl(Utils.getSystemPropertyOrEnvVar(KUBERNETES_MASTER_SYSTEM_PROPERTY, config.getMasterUrl()));
        config.setApiVersion(Utils.getSystemPropertyOrEnvVar(KUBERNETES_API_VERSION_SYSTEM_PROPERTY, config.getApiVersion()));
        config.setNamespace(Utils.getSystemPropertyOrEnvVar(KUBERNETES_NAMESPACE_SYSTEM_PROPERTY, config.getNamespace()));
        config.setCaCertFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getCaCertFile()));
        config.setCaCertData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getCaCertData()));
        config.setClientCertFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getClientCertFile()));
        config.setClientCertData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getClientCertData()));
        config.setClientKeyFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY, config.getClientKeyFile()));
        config.setClientKeyData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY, config.getClientKeyData()));
        config.setClientKeyAlgo(Config.getKeyAlgorithm(config.getClientKeyFile(), config.getClientKeyData()));
        config.setClientKeyPassphrase(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY, config.getClientKeyPassphrase()));
        config.setUserAgent(Utils.getSystemPropertyOrEnvVar(KUBERNETES_USER_AGENT, config.getUserAgent()));
        config.setTrustStorePassphrase(Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUSTSTORE_PASSPHRASE_PROPERTY, config.getTrustStorePassphrase()));
        config.setTrustStoreFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUSTSTORE_FILE_PROPERTY, config.getTrustStoreFile()));
        config.setKeyStorePassphrase(Utils.getSystemPropertyOrEnvVar(KUBERNETES_KEYSTORE_PASSPHRASE_PROPERTY, config.getKeyStorePassphrase()));
        config.setKeyStoreFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_KEYSTORE_FILE_PROPERTY, config.getKeyStoreFile()));
        config.setAutoOAuthToken(Utils.getSystemPropertyOrEnvVar(KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY, config.getAutoOAuthToken()));
        config.setUsername(Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY, config.getUsername()));
        config.setPassword(Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY, config.getPassword()));
        config.setImpersonateUsername(Utils.getSystemPropertyOrEnvVar(KUBERNETES_IMPERSONATE_USERNAME, config.getImpersonateUsername()));
        String configuredImpersonateGroups = Utils.getSystemPropertyOrEnvVar(KUBERNETES_IMPERSONATE_GROUP, Arrays.stream(Optional.ofNullable(config.getImpersonateGroups()).orElse(new String[0])).collect(Collectors.joining(",")));
        if (Utils.isNotNullOrEmpty(configuredImpersonateGroups)) {
            config.setImpersonateGroups(configuredImpersonateGroups.split(","));
        }
        if ((configuredWatchReconnectInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY)) != null) {
            config.setWatchReconnectInterval(Integer.parseInt(configuredWatchReconnectInterval));
        }
        if ((configuredWatchReconnectLimit = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY)) != null) {
            config.setWatchReconnectLimit(Integer.parseInt(configuredWatchReconnectLimit));
        }
        if ((configuredScaleTimeout = Utils.getSystemPropertyOrEnvVar(KUBERNETES_SCALE_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(DEFAULT_SCALE_TIMEOUT))) != null) {
            config.setScaleTimeout(Long.parseLong(configuredScaleTimeout));
        }
        if ((configuredLoggingInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_LOGGING_INTERVAL_SYSTEM_PROPERTY, String.valueOf(20000))) != null) {
            config.setLoggingInterval(Integer.parseInt(configuredLoggingInterval));
        }
        config.setConnectionTimeout(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CONNECTION_TIMEOUT_SYSTEM_PROPERTY, config.getConnectionTimeout()));
        config.setUploadRequestTimeout(Utils.getSystemPropertyOrEnvVar(KUBERNETES_UPLOAD_REQUEST_TIMEOUT_SYSTEM_PROPERTY, config.getUploadRequestTimeout()));
        config.setRequestTimeout(Utils.getSystemPropertyOrEnvVar(KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY, config.getRequestTimeout()));
        config.setRequestRetryBackoffLimit(Utils.getSystemPropertyOrEnvVar(KUBERNETES_REQUEST_RETRY_BACKOFFLIMIT_SYSTEM_PROPERTY, config.getRequestRetryBackoffLimit()));
        config.setRequestRetryBackoffInterval(Utils.getSystemPropertyOrEnvVar(KUBERNETES_REQUEST_RETRY_BACKOFFINTERVAL_SYSTEM_PROPERTY, config.getRequestRetryBackoffInterval()));
        String configuredWebsocketPingInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY, String.valueOf(config.getWebsocketPingInterval()));
        if (configuredWebsocketPingInterval != null) {
            config.setWebsocketPingInterval(Long.parseLong(configuredWebsocketPingInterval));
        }
        if ((configuredMaxConcurrentRequests = Utils.getSystemPropertyOrEnvVar(KUBERNETES_MAX_CONCURRENT_REQUESTS, String.valueOf(config.getMaxConcurrentRequests()))) != null) {
            config.setMaxConcurrentRequests(Integer.parseInt(configuredMaxConcurrentRequests));
        }
        if ((configuredMaxConcurrentReqeustsPerHost = Utils.getSystemPropertyOrEnvVar(KUBERNETES_MAX_CONCURRENT_REQUESTS_PER_HOST, String.valueOf(config.getMaxConcurrentRequestsPerHost()))) != null) {
            config.setMaxConcurrentRequestsPerHost(Integer.parseInt(configuredMaxConcurrentReqeustsPerHost));
        }
        config.setHttp2Disable(Utils.getSystemPropertyOrEnvVar(KUBERNETES_HTTP2_DISABLE, config.isHttp2Disable()));
        if (Utils.isNullOrEmpty(config.getHttpProxy())) {
            config.setHttpProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_ALL_PROXY, config.getHttpProxy()));
            config.setHttpProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_HTTP_PROXY, config.getHttpProxy()));
        }
        if (Utils.isNullOrEmpty(config.getHttpsProxy())) {
            config.setHttpsProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_ALL_PROXY, config.getHttpsProxy()));
            config.setHttpsProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_HTTPS_PROXY, config.getHttpsProxy()));
        }
        config.setProxyUsername(Utils.getSystemPropertyOrEnvVar(KUBERNETES_PROXY_USERNAME, config.getProxyUsername()));
        config.setProxyPassword(Utils.getSystemPropertyOrEnvVar(KUBERNETES_PROXY_PASSWORD, config.getProxyPassword()));
        String noProxyVar = Utils.getSystemPropertyOrEnvVar(KUBERNETES_NO_PROXY);
        if (noProxyVar != null) {
            config.setNoProxy(noProxyVar.split(","));
        }
        if ((tlsVersionsVar = Utils.getSystemPropertyOrEnvVar(KUBERNETES_TLS_VERSIONS)) != null && !tlsVersionsVar.isEmpty()) {
            String[] tlsVersionsSplit = tlsVersionsVar.split(",");
            TlsVersion[] tlsVersions = new TlsVersion[tlsVersionsSplit.length];
            for (int i = 0; i < tlsVersionsSplit.length; ++i) {
                tlsVersions[i] = TlsVersion.forJavaName(tlsVersionsSplit[i]);
            }
            config.setTlsVersions(tlsVersions);
        }
    }

    private static boolean tryServiceAccount(Config config) {
        LOGGER.debug("Trying to configure client from service account...");
        String masterHost = Utils.getSystemPropertyOrEnvVar(KUBERNETES_SERVICE_HOST_PROPERTY, (String)null);
        String masterPort = Utils.getSystemPropertyOrEnvVar(KUBERNETES_SERVICE_PORT_PROPERTY, (String)null);
        String caCertPath = Utils.getSystemPropertyOrEnvVar(KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY, KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH);
        if (masterHost != null && masterPort != null) {
            String hostPort = Config.joinHostPort(masterHost, masterPort);
            LOGGER.debug("Found service account host and port: {}", (Object)hostPort);
            config.setMasterUrl(HTTPS_PROTOCOL_PREFIX + hostPort);
        }
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY, true)) {
            boolean serviceAccountCaCertExists = Files.isRegularFile(new File(caCertPath).toPath(), new LinkOption[0]);
            if (serviceAccountCaCertExists) {
                LOGGER.debug("Found service account ca cert at: [{}}].", (Object)caCertPath);
                config.setCaCertFile(caCertPath);
            } else {
                LOGGER.debug("Did not find service account ca cert at: [{}}].", (Object)caCertPath);
            }
            File saTokenPathFile = Config.findServiceAccountTokenFile();
            if (saTokenPathFile != null) {
                String saTokenPathLocation = saTokenPathFile.getAbsolutePath();
                try {
                    String serviceTokenCandidate = new String(Files.readAllBytes(saTokenPathFile.toPath()));
                    LOGGER.debug("Found service account token at: [{}].", (Object)saTokenPathLocation);
                    config.setAutoOAuthToken(serviceTokenCandidate);
                    return true;
                }
                catch (IOException e) {
                    LOGGER.warn("Error reading service account token from: [{}]. Ignoring.", (Object)saTokenPathLocation);
                }
            }
        }
        return false;
    }

    private static File findServiceAccountTokenFile() {
        File saTokenPathFile;
        String saTokenPath = Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_SERVICEACCOUNT_TOKEN_FILE_SYSTEM_PROPERTY);
        if (saTokenPath != null) {
            saTokenPathFile = new File(saTokenPath);
        } else {
            saTokenPathFile = new File(KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH);
            if (!saTokenPathFile.exists()) {
                saTokenPathFile = null;
                LOGGER.debug("Could not find the service account token at the default location: [{}]. Ignoring.", (Object)KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH);
            }
        }
        return saTokenPathFile;
    }

    private static String joinHostPort(String host, String port) {
        if (host.indexOf(58) >= 0) {
            return "[" + host + "]:" + port;
        }
        return host + ":" + port;
    }

    public static Config fromKubeconfig(String kubeconfigContents) {
        return Config.fromKubeconfig(null, KubeConfigUtils.parseConfigFromString(kubeconfigContents));
    }

    public static Config fromKubeconfig(File kubeconfigFile) {
        return Config.fromKubeconfig(null, kubeconfigFile);
    }

    public static Config fromKubeconfig(String context, File kubeconfig) {
        return Config.fromKubeconfig(context, KubeConfigUtils.parseConfig(kubeconfig));
    }

    private static Config fromKubeconfig(String context, io.fabric8.kubernetes.api.model.Config ... kubeconfigs) {
        Config ret = Config.empty();
        KubeConfigUtils.merge(ret, context, kubeconfigs);
        return ret;
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    public static Config fromKubeconfig(String context, String kubeconfigContents, String kubeconfigPath) {
        Config config = new Config(false);
        if (Utils.isNullOrEmpty(kubeconfigContents)) {
            throw new KubernetesClientException("Could not create Config from kubeconfig");
        }
        io.fabric8.kubernetes.api.model.Config kubeconfig = kubeconfigPath != null ? KubeConfigUtils.parseConfig(new File(kubeconfigPath)) : KubeConfigUtils.parseConfigFromString(kubeconfigContents);
        KubeConfigUtils.merge(config, context, kubeconfig);
        if (!Config.disableAutoConfig()) {
            Config.postAutoConfigure(config);
        }
        return config;
    }

    public Config refresh() {
        String currentContextName;
        String string = currentContextName = this.getCurrentContext() != null ? this.getCurrentContext().getName() : null;
        if (Utils.isNotNullOrEmpty(this.getOauthToken())) {
            return this;
        }
        if (Boolean.TRUE.equals(this.getAutoConfigure())) {
            return Config.autoConfigure(currentContextName);
        }
        if (this.getFile() != null) {
            if (Config.loadKubeConfigContents(this.getFile()) == null) {
                return this;
            }
            Config refreshedConfig = Config.fromKubeconfig(currentContextName, this.getFile());
            if (!Config.disableAutoConfig()) {
                Config.postAutoConfigure(refreshedConfig);
            }
            return refreshedConfig;
        }
        return this;
    }

    private static Collection<File> findKubeConfigFiles() {
        LOGGER.debug("Trying to configure client from Kubernetes config...");
        if (!Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY, true)) {
            return Collections.emptyList();
        }
        return Config.getKubeconfigFilenames().stream().map(File::new).filter(f -> {
            if (!f.isFile()) {
                LOGGER.debug("Did not find Kubernetes config at: [{}]. Ignoring.", (Object)f.getPath());
                return false;
            }
            return true;
        }).filter(f -> Utils.isNotNullOrEmpty(Config.loadKubeConfigContents(f))).collect(Collectors.toList());
    }

    public static Collection<String> getKubeconfigFilenames() {
        String valueOrDefault = Utils.getSystemPropertyOrEnvVar(KUBERNETES_KUBECONFIG_FILE, new File(Config.getHomeDir(), ".kube" + File.separator + "config").toString());
        return Arrays.asList(valueOrDefault.split(File.pathSeparator));
    }

    private static String loadKubeConfigContents(File kubeConfigFile) {
        String string;
        FileReader reader = new FileReader(kubeConfigFile);
        try {
            string = IOHelpers.readFully(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Could not load Kubernetes config file from {}", (Object)kubeConfigFile.getPath(), (Object)e);
                return null;
            }
        }
        reader.close();
        return string;
    }

    private static boolean tryNamespaceFromPath(Config config) {
        LOGGER.debug("Trying to configure client namespace from Kubernetes service account namespace path...");
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRYNAMESPACE_PATH_SYSTEM_PROPERTY, true)) {
            String serviceAccountNamespace = Utils.getSystemPropertyOrEnvVar(KUBERNETES_NAMESPACE_FILE, KUBERNETES_NAMESPACE_PATH);
            boolean serviceAccountNamespaceExists = Files.isRegularFile(new File(serviceAccountNamespace).toPath(), new LinkOption[0]);
            if (serviceAccountNamespaceExists) {
                LOGGER.debug("Found service account namespace at: [{}].", (Object)serviceAccountNamespace);
                try {
                    String namespace = new String(Files.readAllBytes(new File(serviceAccountNamespace).toPath()));
                    config.setNamespace(namespace.replace(System.lineSeparator(), ""));
                    return true;
                }
                catch (IOException e) {
                    LOGGER.error("Error reading service account namespace from: [" + serviceAccountNamespace + "].", e);
                }
            } else {
                LOGGER.debug("Did not find service account namespace at: [{}]. Ignoring.", (Object)serviceAccountNamespace);
            }
        }
        return false;
    }

    private static String getHomeDir() {
        return Config.getHomeDir(Config::isDirectoryAndExists, Config::getSystemEnvVariable);
    }

    private static boolean isDirectoryAndExists(String filePath) {
        File f = new File(filePath);
        return f.exists() && f.isDirectory();
    }

    private static String getSystemEnvVariable(String envVariableName) {
        return System.getenv(envVariableName);
    }

    protected static String getHomeDir(Predicate<String> directoryExists, UnaryOperator<String> getEnvVar) {
        String home = (String)getEnvVar.apply("HOME");
        if (home != null && !home.isEmpty() && directoryExists.test(home)) {
            return home;
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.startsWith("win")) {
            String homeDir;
            String homeDrive = (String)getEnvVar.apply("HOMEDRIVE");
            String homePath = (String)getEnvVar.apply("HOMEPATH");
            if (homeDrive != null && !homeDrive.isEmpty() && homePath != null && !homePath.isEmpty() && directoryExists.test(homeDir = homeDrive + homePath)) {
                return homeDir;
            }
            String userProfile = (String)getEnvVar.apply("USERPROFILE");
            if (userProfile != null && !userProfile.isEmpty() && directoryExists.test(userProfile)) {
                return userProfile;
            }
        }
        return System.getProperty("user.home", ".");
    }

    public static String getKeyAlgorithm(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            String algorithm = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains("BEGIN EC PRIVATE KEY")) {
                    algorithm = "EC";
                    continue;
                }
                if (!line.contains("BEGIN RSA PRIVATE KEY")) continue;
                algorithm = "RSA";
            }
            String string = algorithm;
            return string;
        }
    }

    public static String getKeyAlgorithm(String clientKeyFile, String clientKeyData) {
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY) != null) {
            return Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY);
        }
        try {
            if (clientKeyData != null || clientKeyFile != null) {
                ByteArrayInputStream keyInputStream = CertUtils.getInputStreamFromDataOrFile(clientKeyData, clientKeyFile);
                return Config.getKeyAlgorithm(keyInputStream);
            }
        }
        catch (IOException exception) {
            LOGGER.debug("Failure in determining private key algorithm type, defaulting to RSA {}", (Object)exception.getMessage());
        }
        return null;
    }

    @Override
    @JsonProperty(value="impersonateUsername")
    public String getImpersonateUsername() {
        return this.getRequestConfig().getImpersonateUsername();
    }

    @Override
    public void setImpersonateUsername(String impersonateUsername) {
        this.requestConfig.setImpersonateUsername(impersonateUsername);
    }

    @Override
    @JsonProperty(value="impersonateGroups")
    public String[] getImpersonateGroups() {
        return this.getRequestConfig().getImpersonateGroups();
    }

    @Override
    public void setImpersonateGroups(String ... impersonateGroup) {
        this.requestConfig.setImpersonateGroups(impersonateGroup);
    }

    @Override
    @JsonProperty(value="impersonateExtras")
    public Map<String, List<String>> getImpersonateExtras() {
        return this.getRequestConfig().getImpersonateExtras();
    }

    @Override
    public void setImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.requestConfig.setImpersonateExtras(impersonateExtras);
    }

    @Override
    public void setMasterUrl(String masterUrl) {
        super.setMasterUrl(masterUrl);
        super.setMasterUrl(Config.ensureEndsWithSlash(Config.ensureHttps(masterUrl, this)));
    }

    @JsonProperty(value="trustCerts")
    public boolean isTrustCerts() {
        return Optional.ofNullable(this.getTrustCerts()).orElse(false);
    }

    public void setTrustCerts(boolean trustCerts) {
        this.setTrustCerts((Boolean)trustCerts);
    }

    @JsonProperty(value="disableHostnameVerification")
    public boolean isDisableHostnameVerification() {
        return Optional.ofNullable(this.getDisableHostnameVerification()).orElse(false);
    }

    public void setDisableHostnameVerification(boolean disableHostnameVerification) {
        this.setDisableHostnameVerification((Boolean)disableHostnameVerification);
    }

    @Override
    @JsonProperty(value="watchReconnectInterval")
    public Integer getWatchReconnectInterval() {
        return this.requestConfig.getWatchReconnectInterval();
    }

    @Override
    public void setWatchReconnectInterval(Integer watchReconnectInterval) {
        this.requestConfig.setWatchReconnectInterval(watchReconnectInterval);
    }

    @Override
    @JsonProperty(value="watchReconnectLimit")
    public Integer getWatchReconnectLimit() {
        return this.getRequestConfig().getWatchReconnectLimit();
    }

    @Override
    public void setWatchReconnectLimit(Integer watchReconnectLimit) {
        this.requestConfig.setWatchReconnectLimit(watchReconnectLimit);
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    @Override
    @JsonProperty(value="uploadRequestTimeout")
    public Integer getUploadRequestTimeout() {
        return this.getRequestConfig().getUploadRequestTimeout();
    }

    @Override
    public void setUploadRequestTimeout(Integer requestTimeout) {
        this.requestConfig.setUploadRequestTimeout(requestTimeout);
    }

    @Override
    @JsonProperty(value="requestTimeout")
    public Integer getRequestTimeout() {
        return this.getRequestConfig().getRequestTimeout();
    }

    @Override
    public void setRequestTimeout(Integer requestTimeout) {
        this.requestConfig.setRequestTimeout(requestTimeout);
    }

    @Override
    @JsonProperty(value="requestRetryBackoffLimit")
    public Integer getRequestRetryBackoffLimit() {
        return this.getRequestConfig().getRequestRetryBackoffLimit();
    }

    @Override
    public void setRequestRetryBackoffLimit(Integer requestRetryBackoffLimit) {
        this.requestConfig.setRequestRetryBackoffLimit(requestRetryBackoffLimit);
    }

    @Override
    @JsonProperty(value="requestRetryBackoffInterval")
    public Integer getRequestRetryBackoffInterval() {
        return this.getRequestConfig().getRequestRetryBackoffInterval();
    }

    @Override
    public void setRequestRetryBackoffInterval(Integer requestRetryBackoffInterval) {
        this.requestConfig.setRequestRetryBackoffInterval(requestRetryBackoffInterval);
    }

    @Override
    @JsonProperty(value="scaleTimeout")
    public Long getScaleTimeout() {
        return this.getRequestConfig().getScaleTimeout();
    }

    @Override
    public void setScaleTimeout(Long scaleTimeout) {
        this.requestConfig.setScaleTimeout(scaleTimeout);
    }

    @Override
    @JsonProperty(value="loggingInterval")
    public Integer getLoggingInterval() {
        return this.getRequestConfig().getLoggingInterval();
    }

    @Override
    public void setLoggingInterval(Integer loggingInterval) {
        this.requestConfig.setLoggingInterval(loggingInterval);
    }

    @JsonProperty(value="http2Disable")
    public boolean isHttp2Disable() {
        return Optional.ofNullable(this.getHttp2Disable()).orElse(false);
    }

    @JsonProperty(value="defaultNamespace")
    public boolean isDefaultNamespace() {
        return Optional.ofNullable(this.getDefaultNamespace()).orElse(true);
    }

    public void setDefaultNamespace(boolean defaultNamespace) {
        this.setDefaultNamespace((Boolean)defaultNamespace);
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public File getFile() {
        return KubeConfigUtils.getFileWithNamedContext(this.getCurrentContext());
    }

    public File getFileWithCluster() {
        return KubeConfigUtils.getFileWithNamedCluster(this.getCurrentContext());
    }

    public File getFileWithAuthInfo() {
        return KubeConfigUtils.getFileWithNamedAuthInfo(this.getCurrentContext());
    }

    @JsonIgnore
    public Readiness getReadiness() {
        return Readiness.getInstance();
    }

    public boolean isOnlyHttpWatches() {
        return Optional.ofNullable(this.getOnlyHttpWatches()).orElse(false);
    }

    public void setOnlyHttpWatches(boolean onlyHttpWatches) {
        this.setOnlyHttpWatches((Boolean)onlyHttpWatches);
    }

    public boolean isWatchList() {
        return Optional.ofNullable(this.getWatchList()).orElse(false);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class ExecCredentialStatus {
        public String token;
        public String clientCertificateData;
        public String clientKeyData;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class ExecCredentialSpec {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class ExecCredential {
        public String kind;
        public String apiVersion;
        public ExecCredentialSpec spec;
        public ExecCredentialStatus status;
    }
}

