/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.resource.v1.CapacityRequestPolicy;
import io.fabric8.kubernetes.api.model.resource.v1.CapacityRequestPolicyBuilder;
import io.fabric8.kubernetes.api.model.resource.v1.CapacityRequestPolicyFluent;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceCapacity;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeviceCapacityFluent<A extends DeviceCapacityFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private CapacityRequestPolicyBuilder requestPolicy;
    private Quantity value;

    public DeviceCapacityFluent() {
    }

    public DeviceCapacityFluent(DeviceCapacity instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public CapacityRequestPolicy buildRequestPolicy() {
        return this.requestPolicy != null ? this.requestPolicy.build() : null;
    }

    protected void copyInstance(DeviceCapacity instance) {
        DeviceCapacity deviceCapacity = instance = instance != null ? instance : new DeviceCapacity();
        if (instance != null) {
            this.withRequestPolicy(instance.getRequestPolicy());
            this.withValue(instance.getValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RequestPolicyNested<A> editOrNewRequestPolicy() {
        return this.withNewRequestPolicyLike(Optional.ofNullable(this.buildRequestPolicy()).orElse(new CapacityRequestPolicyBuilder().build()));
    }

    public RequestPolicyNested<A> editOrNewRequestPolicyLike(CapacityRequestPolicy item) {
        return this.withNewRequestPolicyLike(Optional.ofNullable(this.buildRequestPolicy()).orElse(item));
    }

    public RequestPolicyNested<A> editRequestPolicy() {
        return this.withNewRequestPolicyLike(Optional.ofNullable(this.buildRequestPolicy()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceCapacityFluent that = (DeviceCapacityFluent)o;
        if (!Objects.equals(this.requestPolicy, that.requestPolicy)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Quantity getValue() {
        return this.value;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasRequestPolicy() {
        return this.requestPolicy != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.requestPolicy, this.value, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.requestPolicy != null) {
            sb.append("requestPolicy:");
            sb.append(this.requestPolicy);
            sb.append(",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public RequestPolicyNested<A> withNewRequestPolicy() {
        return new RequestPolicyNested(null);
    }

    public RequestPolicyNested<A> withNewRequestPolicyLike(CapacityRequestPolicy item) {
        return new RequestPolicyNested(item);
    }

    public A withNewValue(String amount) {
        return this.withValue(new Quantity(amount));
    }

    public A withNewValue(String amount, String format) {
        return this.withValue(new Quantity(amount, format));
    }

    public A withRequestPolicy(CapacityRequestPolicy requestPolicy) {
        this._visitables.remove("requestPolicy");
        if (requestPolicy != null) {
            this.requestPolicy = new CapacityRequestPolicyBuilder(requestPolicy);
            this._visitables.get("requestPolicy").add(this.requestPolicy);
        } else {
            this.requestPolicy = null;
            this._visitables.get("requestPolicy").remove(this.requestPolicy);
        }
        return (A)this;
    }

    public A withValue(Quantity value) {
        this.value = value;
        return (A)this;
    }

    public class RequestPolicyNested<N>
    extends CapacityRequestPolicyFluent<RequestPolicyNested<N>>
    implements Nested<N> {
        CapacityRequestPolicyBuilder builder;

        RequestPolicyNested(CapacityRequestPolicy item) {
            this.builder = new CapacityRequestPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceCapacityFluent.this.withRequestPolicy(this.builder.build());
        }

        public N endRequestPolicy() {
            return this.and();
        }
    }
}

