/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayInfrastructure;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalParametersReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalParametersReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GatewayInfrastructureFluent<A extends GatewayInfrastructureFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Map<String, String> annotations;
    private Map<String, String> labels;
    private LocalParametersReferenceBuilder parametersRef;

    public GatewayInfrastructureFluent() {
    }

    public GatewayInfrastructureFluent(GatewayInfrastructure instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    public LocalParametersReference buildParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    protected void copyInstance(GatewayInfrastructure instance) {
        GatewayInfrastructure gatewayInfrastructure = instance = instance != null ? instance : new GatewayInfrastructure();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withLabels(instance.getLabels());
            this.withParametersRef(instance.getParametersRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ParametersRefNested<A> editOrNewParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(new LocalParametersReferenceBuilder().build()));
    }

    public ParametersRefNested<A> editOrNewParametersRefLike(LocalParametersReference item) {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(item));
    }

    public ParametersRefNested<A> editParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewayInfrastructureFluent that = (GatewayInfrastructureFluent)o;
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.parametersRef, that.parametersRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public boolean hasParametersRef() {
        return this.parametersRef != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotations, this.labels, this.parametersRef, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations);
            sb.append(",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels);
            sb.append(",");
        }
        if (this.parametersRef != null) {
            sb.append("parametersRef:");
            sb.append(this.parametersRef);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    public ParametersRefNested<A> withNewParametersRef() {
        return new ParametersRefNested(null);
    }

    public A withNewParametersRef(String group, String kind, String name) {
        return this.withParametersRef(new LocalParametersReference(group, kind, name));
    }

    public ParametersRefNested<A> withNewParametersRefLike(LocalParametersReference item) {
        return new ParametersRefNested(item);
    }

    public A withParametersRef(LocalParametersReference parametersRef) {
        this._visitables.remove("parametersRef");
        if (parametersRef != null) {
            this.parametersRef = new LocalParametersReferenceBuilder(parametersRef);
            this._visitables.get("parametersRef").add(this.parametersRef);
        } else {
            this.parametersRef = null;
            this._visitables.get("parametersRef").remove(this.parametersRef);
        }
        return (A)this;
    }

    public class ParametersRefNested<N>
    extends LocalParametersReferenceFluent<ParametersRefNested<N>>
    implements Nested<N> {
        LocalParametersReferenceBuilder builder;

        ParametersRefNested(LocalParametersReference item) {
            this.builder = new LocalParametersReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewayInfrastructureFluent.this.withParametersRef(this.builder.build());
        }

        public N endParametersRef() {
            return this.and();
        }
    }
}

