/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSwapStatus;
import io.fabric8.kubernetes.api.model.NodeSwapStatusBuilder;
import io.fabric8.kubernetes.api.model.NodeSwapStatusFluent;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeSystemInfoFluent<A extends NodeSystemInfoFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String architecture;
    private String bootID;
    private String containerRuntimeVersion;
    private String kernelVersion;
    private String kubeProxyVersion;
    private String kubeletVersion;
    private String machineID;
    private String operatingSystem;
    private String osImage;
    private NodeSwapStatusBuilder swap;
    private String systemUUID;

    public NodeSystemInfoFluent() {
    }

    public NodeSystemInfoFluent(NodeSystemInfo instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public NodeSwapStatus buildSwap() {
        return this.swap != null ? this.swap.build() : null;
    }

    protected void copyInstance(NodeSystemInfo instance) {
        NodeSystemInfo nodeSystemInfo = instance = instance != null ? instance : new NodeSystemInfo();
        if (instance != null) {
            this.withArchitecture(instance.getArchitecture());
            this.withBootID(instance.getBootID());
            this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
            this.withKernelVersion(instance.getKernelVersion());
            this.withKubeProxyVersion(instance.getKubeProxyVersion());
            this.withKubeletVersion(instance.getKubeletVersion());
            this.withMachineID(instance.getMachineID());
            this.withOperatingSystem(instance.getOperatingSystem());
            this.withOsImage(instance.getOsImage());
            this.withSwap(instance.getSwap());
            this.withSystemUUID(instance.getSystemUUID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SwapNested<A> editOrNewSwap() {
        return this.withNewSwapLike(Optional.ofNullable(this.buildSwap()).orElse(new NodeSwapStatusBuilder().build()));
    }

    public SwapNested<A> editOrNewSwapLike(NodeSwapStatus item) {
        return this.withNewSwapLike(Optional.ofNullable(this.buildSwap()).orElse(item));
    }

    public SwapNested<A> editSwap() {
        return this.withNewSwapLike(Optional.ofNullable(this.buildSwap()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSystemInfoFluent that = (NodeSystemInfoFluent)o;
        if (!Objects.equals(this.architecture, that.architecture)) {
            return false;
        }
        if (!Objects.equals(this.bootID, that.bootID)) {
            return false;
        }
        if (!Objects.equals(this.containerRuntimeVersion, that.containerRuntimeVersion)) {
            return false;
        }
        if (!Objects.equals(this.kernelVersion, that.kernelVersion)) {
            return false;
        }
        if (!Objects.equals(this.kubeProxyVersion, that.kubeProxyVersion)) {
            return false;
        }
        if (!Objects.equals(this.kubeletVersion, that.kubeletVersion)) {
            return false;
        }
        if (!Objects.equals(this.machineID, that.machineID)) {
            return false;
        }
        if (!Objects.equals(this.operatingSystem, that.operatingSystem)) {
            return false;
        }
        if (!Objects.equals(this.osImage, that.osImage)) {
            return false;
        }
        if (!Objects.equals(this.swap, that.swap)) {
            return false;
        }
        if (!Objects.equals(this.systemUUID, that.systemUUID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getBootID() {
        return this.bootID;
    }

    public String getContainerRuntimeVersion() {
        return this.containerRuntimeVersion;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public String getKubeProxyVersion() {
        return this.kubeProxyVersion;
    }

    public String getKubeletVersion() {
        return this.kubeletVersion;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOsImage() {
        return this.osImage;
    }

    public String getSystemUUID() {
        return this.systemUUID;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasArchitecture() {
        return this.architecture != null;
    }

    public boolean hasBootID() {
        return this.bootID != null;
    }

    public boolean hasContainerRuntimeVersion() {
        return this.containerRuntimeVersion != null;
    }

    public boolean hasKernelVersion() {
        return this.kernelVersion != null;
    }

    public boolean hasKubeProxyVersion() {
        return this.kubeProxyVersion != null;
    }

    public boolean hasKubeletVersion() {
        return this.kubeletVersion != null;
    }

    public boolean hasMachineID() {
        return this.machineID != null;
    }

    public boolean hasOperatingSystem() {
        return this.operatingSystem != null;
    }

    public boolean hasOsImage() {
        return this.osImage != null;
    }

    public boolean hasSwap() {
        return this.swap != null;
    }

    public boolean hasSystemUUID() {
        return this.systemUUID != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.architecture, this.bootID, this.containerRuntimeVersion, this.kernelVersion, this.kubeProxyVersion, this.kubeletVersion, this.machineID, this.operatingSystem, this.osImage, this.swap, this.systemUUID, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture != null) {
            sb.append("architecture:");
            sb.append(this.architecture);
            sb.append(",");
        }
        if (this.bootID != null) {
            sb.append("bootID:");
            sb.append(this.bootID);
            sb.append(",");
        }
        if (this.containerRuntimeVersion != null) {
            sb.append("containerRuntimeVersion:");
            sb.append(this.containerRuntimeVersion);
            sb.append(",");
        }
        if (this.kernelVersion != null) {
            sb.append("kernelVersion:");
            sb.append(this.kernelVersion);
            sb.append(",");
        }
        if (this.kubeProxyVersion != null) {
            sb.append("kubeProxyVersion:");
            sb.append(this.kubeProxyVersion);
            sb.append(",");
        }
        if (this.kubeletVersion != null) {
            sb.append("kubeletVersion:");
            sb.append(this.kubeletVersion);
            sb.append(",");
        }
        if (this.machineID != null) {
            sb.append("machineID:");
            sb.append(this.machineID);
            sb.append(",");
        }
        if (this.operatingSystem != null) {
            sb.append("operatingSystem:");
            sb.append(this.operatingSystem);
            sb.append(",");
        }
        if (this.osImage != null) {
            sb.append("osImage:");
            sb.append(this.osImage);
            sb.append(",");
        }
        if (this.swap != null) {
            sb.append("swap:");
            sb.append(this.swap);
            sb.append(",");
        }
        if (this.systemUUID != null) {
            sb.append("systemUUID:");
            sb.append(this.systemUUID);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withArchitecture(String architecture) {
        this.architecture = architecture;
        return (A)this;
    }

    public A withBootID(String bootID) {
        this.bootID = bootID;
        return (A)this;
    }

    public A withContainerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion = containerRuntimeVersion;
        return (A)this;
    }

    public A withKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
        return (A)this;
    }

    public A withKubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion = kubeProxyVersion;
        return (A)this;
    }

    public A withKubeletVersion(String kubeletVersion) {
        this.kubeletVersion = kubeletVersion;
        return (A)this;
    }

    public A withMachineID(String machineID) {
        this.machineID = machineID;
        return (A)this;
    }

    public SwapNested<A> withNewSwap() {
        return new SwapNested(null);
    }

    public A withNewSwap(Long capacity) {
        return this.withSwap(new NodeSwapStatus(capacity));
    }

    public SwapNested<A> withNewSwapLike(NodeSwapStatus item) {
        return new SwapNested(item);
    }

    public A withOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return (A)this;
    }

    public A withOsImage(String osImage) {
        this.osImage = osImage;
        return (A)this;
    }

    public A withSwap(NodeSwapStatus swap) {
        this._visitables.remove("swap");
        if (swap != null) {
            this.swap = new NodeSwapStatusBuilder(swap);
            this._visitables.get("swap").add(this.swap);
        } else {
            this.swap = null;
            this._visitables.get("swap").remove(this.swap);
        }
        return (A)this;
    }

    public A withSystemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
        return (A)this;
    }

    public class SwapNested<N>
    extends NodeSwapStatusFluent<SwapNested<N>>
    implements Nested<N> {
        NodeSwapStatusBuilder builder;

        SwapNested(NodeSwapStatus item) {
            this.builder = new NodeSwapStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeSystemInfoFluent.this.withSwap(this.builder.build());
        }

        public N endSwap() {
            return this.and();
        }
    }
}

