/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.collector;

import io.fabric8.crd.generator.collector.CustomResourceClassLoaderException;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomResourceClassLoader {
    private static final Logger log = LoggerFactory.getLogger(CustomResourceClassLoader.class);
    private final Set<String> classpathElements = new LinkedHashSet<String>();
    private ClassLoader parentClassLoader;
    private ClassLoader cachedClassLoader;

    CustomResourceClassLoader() {
    }

    public CustomResourceClassLoader withParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    public CustomResourceClassLoader withClasspathElement(String ... classpathElements) {
        if (classpathElements != null) {
            this.withClasspathElements(Arrays.asList(classpathElements));
        }
        return this;
    }

    public CustomResourceClassLoader withClasspathElements(Collection<String> classpathElements) {
        if (classpathElements != null) {
            classpathElements.stream().filter(Objects::nonNull).forEach(this.classpathElements::add);
        }
        return this;
    }

    public Class<? extends HasMetadata> loadCustomResourceClass(String className) {
        Class<?> clazz = this.loadClass(className);
        if (HasMetadata.class.isAssignableFrom(clazz)) {
            return clazz.asSubclass(HasMetadata.class);
        }
        throw new CustomResourceClassLoaderException("Could not load Custom Resource. Class does not implement HasMetadata: " + className);
    }

    private Class<?> loadClass(String className) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CustomResourceClassLoaderException(e);
        }
    }

    ClassLoader getClassLoader() {
        if (this.cachedClassLoader == null) {
            this.cachedClassLoader = this.createClassLoader();
        }
        return this.cachedClassLoader;
    }

    private ClassLoader createClassLoader() {
        if (!this.classpathElements.isEmpty()) {
            Object[] urls = (URL[])this.classpathElements.stream().map(s -> {
                try {
                    return new File((String)s).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new CustomResourceClassLoaderException("Could not transform file to URL: " + s, e);
                }
            }).toArray(URL[]::new);
            String urlsAsString = Arrays.toString(urls);
            if (this.parentClassLoader != null) {
                log.trace("Using URLClassLoader with parent ClassLoader {} and {}", (Object)this.parentClassLoader, (Object)urlsAsString);
                return new URLClassLoader((URL[])urls, this.parentClassLoader);
            }
            log.trace("Using URLClassLoader with {}", (Object)urlsAsString);
            return new URLClassLoader((URL[])urls);
        }
        if (this.parentClassLoader != null) {
            log.trace("Using given ClassLoader {}", (Object)this.parentClassLoader);
            return this.parentClassLoader;
        }
        log.trace("Using default ClassLoader");
        return this.getDefaultClassLoader();
    }

    private ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    void reset() {
        this.classpathElements.clear();
        this.parentClassLoader = null;
        this.cachedClassLoader = null;
    }
}

