/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceClaim;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceClaimConfiguration;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceClaimConfigurationBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceClaimConfigurationFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceConstraint;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceConstraintBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceConstraintFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceRequest;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceRequestBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceRequestFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceClaimFluent<A extends DeviceClaimFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DeviceClaimConfigurationBuilder> config = new ArrayList();
    private ArrayList<DeviceConstraintBuilder> constraints = new ArrayList();
    private ArrayList<DeviceRequestBuilder> requests = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DeviceClaimFluent() {
    }

    public DeviceClaimFluent(DeviceClaim instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeviceClaim instance) {
        DeviceClaim deviceClaim = instance = instance != null ? instance : new DeviceClaim();
        if (instance != null) {
            this.withConfig(instance.getConfig());
            this.withConstraints(instance.getConstraints());
            this.withRequests(instance.getRequests());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConfig(int index, DeviceClaimConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        DeviceClaimConfigurationBuilder builder = new DeviceClaimConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get("config").add(index, builder);
            this.config.add(index, builder);
        }
        return (A)this;
    }

    public A setToConfig(int index, DeviceClaimConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        DeviceClaimConfigurationBuilder builder = new DeviceClaimConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get("config").set(index, builder);
            this.config.set(index, builder);
        }
        return (A)this;
    }

    public A addToConfig(DeviceClaimConfiguration ... items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (DeviceClaimConfiguration item : items) {
            DeviceClaimConfigurationBuilder builder = new DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        }
        return (A)this;
    }

    public A addAllToConfig(Collection<DeviceClaimConfiguration> items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (DeviceClaimConfiguration item : items) {
            DeviceClaimConfigurationBuilder builder = new DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").add(builder);
            this.config.add(builder);
        }
        return (A)this;
    }

    public A removeFromConfig(DeviceClaimConfiguration ... items) {
        if (this.config == null) {
            return (A)this;
        }
        for (DeviceClaimConfiguration item : items) {
            DeviceClaimConfigurationBuilder builder = new DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").remove(builder);
            this.config.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConfig(Collection<DeviceClaimConfiguration> items) {
        if (this.config == null) {
            return (A)this;
        }
        for (DeviceClaimConfiguration item : items) {
            DeviceClaimConfigurationBuilder builder = new DeviceClaimConfigurationBuilder(item);
            this._visitables.get("config").remove(builder);
            this.config.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConfig(Predicate<DeviceClaimConfigurationBuilder> predicate) {
        if (this.config == null) {
            return (A)this;
        }
        Iterator<DeviceClaimConfigurationBuilder> each = this.config.iterator();
        Object visitables = this._visitables.get("config");
        while (each.hasNext()) {
            DeviceClaimConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceClaimConfiguration> buildConfig() {
        return this.config != null ? DeviceClaimFluent.build(this.config) : null;
    }

    public DeviceClaimConfiguration buildConfig(int index) {
        return this.config.get(index).build();
    }

    public DeviceClaimConfiguration buildFirstConfig() {
        return this.config.get(0).build();
    }

    public DeviceClaimConfiguration buildLastConfig() {
        return this.config.get(this.config.size() - 1).build();
    }

    public DeviceClaimConfiguration buildMatchingConfig(Predicate<DeviceClaimConfigurationBuilder> predicate) {
        for (DeviceClaimConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfig(Predicate<DeviceClaimConfigurationBuilder> predicate) {
        for (DeviceClaimConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfig(List<DeviceClaimConfiguration> config) {
        if (this.config != null) {
            this._visitables.get("config").clear();
        }
        if (config != null) {
            this.config = new ArrayList();
            for (DeviceClaimConfiguration item : config) {
                this.addToConfig(item);
            }
        } else {
            this.config = null;
        }
        return (A)this;
    }

    public A withConfig(DeviceClaimConfiguration ... config) {
        if (this.config != null) {
            this.config.clear();
            this._visitables.remove("config");
        }
        if (config != null) {
            for (DeviceClaimConfiguration item : config) {
                this.addToConfig(item);
            }
        }
        return (A)this;
    }

    public boolean hasConfig() {
        return this.config != null && !this.config.isEmpty();
    }

    public ConfigNested<A> addNewConfig() {
        return new ConfigNested(-1, null);
    }

    public ConfigNested<A> addNewConfigLike(DeviceClaimConfiguration item) {
        return new ConfigNested(-1, item);
    }

    public ConfigNested<A> setNewConfigLike(int index, DeviceClaimConfiguration item) {
        return new ConfigNested(index, item);
    }

    public ConfigNested<A> editConfig(int index) {
        if (this.config.size() <= index) {
            throw new RuntimeException("Can't edit config. Index exceeds size.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigNested<A> editFirstConfig() {
        if (this.config.size() == 0) {
            throw new RuntimeException("Can't edit first config. The list is empty.");
        }
        return this.setNewConfigLike(0, this.buildConfig(0));
    }

    public ConfigNested<A> editLastConfig() {
        int index = this.config.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last config. The list is empty.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigNested<A> editMatchingConfig(Predicate<DeviceClaimConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.config.size(); ++i) {
            if (!predicate.test(this.config.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching config. No match found.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public A addToConstraints(int index, DeviceConstraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        DeviceConstraintBuilder builder = new DeviceConstraintBuilder(item);
        if (index < 0 || index >= this.constraints.size()) {
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        } else {
            this._visitables.get("constraints").add(index, builder);
            this.constraints.add(index, builder);
        }
        return (A)this;
    }

    public A setToConstraints(int index, DeviceConstraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        DeviceConstraintBuilder builder = new DeviceConstraintBuilder(item);
        if (index < 0 || index >= this.constraints.size()) {
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        } else {
            this._visitables.get("constraints").set(index, builder);
            this.constraints.set(index, builder);
        }
        return (A)this;
    }

    public A addToConstraints(DeviceConstraint ... items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        for (DeviceConstraint item : items) {
            DeviceConstraintBuilder builder = new DeviceConstraintBuilder(item);
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    public A addAllToConstraints(Collection<DeviceConstraint> items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        for (DeviceConstraint item : items) {
            DeviceConstraintBuilder builder = new DeviceConstraintBuilder(item);
            this._visitables.get("constraints").add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    public A removeFromConstraints(DeviceConstraint ... items) {
        if (this.constraints == null) {
            return (A)this;
        }
        for (DeviceConstraint item : items) {
            DeviceConstraintBuilder builder = new DeviceConstraintBuilder(item);
            this._visitables.get("constraints").remove(builder);
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConstraints(Collection<DeviceConstraint> items) {
        if (this.constraints == null) {
            return (A)this;
        }
        for (DeviceConstraint item : items) {
            DeviceConstraintBuilder builder = new DeviceConstraintBuilder(item);
            this._visitables.get("constraints").remove(builder);
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConstraints(Predicate<DeviceConstraintBuilder> predicate) {
        if (this.constraints == null) {
            return (A)this;
        }
        Iterator<DeviceConstraintBuilder> each = this.constraints.iterator();
        Object visitables = this._visitables.get("constraints");
        while (each.hasNext()) {
            DeviceConstraintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceConstraint> buildConstraints() {
        return this.constraints != null ? DeviceClaimFluent.build(this.constraints) : null;
    }

    public DeviceConstraint buildConstraint(int index) {
        return this.constraints.get(index).build();
    }

    public DeviceConstraint buildFirstConstraint() {
        return this.constraints.get(0).build();
    }

    public DeviceConstraint buildLastConstraint() {
        return this.constraints.get(this.constraints.size() - 1).build();
    }

    public DeviceConstraint buildMatchingConstraint(Predicate<DeviceConstraintBuilder> predicate) {
        for (DeviceConstraintBuilder item : this.constraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConstraint(Predicate<DeviceConstraintBuilder> predicate) {
        for (DeviceConstraintBuilder item : this.constraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConstraints(List<DeviceConstraint> constraints) {
        if (this.constraints != null) {
            this._visitables.get("constraints").clear();
        }
        if (constraints != null) {
            this.constraints = new ArrayList();
            for (DeviceConstraint item : constraints) {
                this.addToConstraints(item);
            }
        } else {
            this.constraints = null;
        }
        return (A)this;
    }

    public A withConstraints(DeviceConstraint ... constraints) {
        if (this.constraints != null) {
            this.constraints.clear();
            this._visitables.remove("constraints");
        }
        if (constraints != null) {
            for (DeviceConstraint item : constraints) {
                this.addToConstraints(item);
            }
        }
        return (A)this;
    }

    public boolean hasConstraints() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    public ConstraintsNested<A> addNewConstraint() {
        return new ConstraintsNested(-1, null);
    }

    public ConstraintsNested<A> addNewConstraintLike(DeviceConstraint item) {
        return new ConstraintsNested(-1, item);
    }

    public ConstraintsNested<A> setNewConstraintLike(int index, DeviceConstraint item) {
        return new ConstraintsNested(index, item);
    }

    public ConstraintsNested<A> editConstraint(int index) {
        if (this.constraints.size() <= index) {
            throw new RuntimeException("Can't edit constraints. Index exceeds size.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    public ConstraintsNested<A> editFirstConstraint() {
        if (this.constraints.size() == 0) {
            throw new RuntimeException("Can't edit first constraints. The list is empty.");
        }
        return this.setNewConstraintLike(0, this.buildConstraint(0));
    }

    public ConstraintsNested<A> editLastConstraint() {
        int index = this.constraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last constraints. The list is empty.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    public ConstraintsNested<A> editMatchingConstraint(Predicate<DeviceConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (!predicate.test(this.constraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching constraints. No match found.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    public A addToRequests(int index, DeviceRequest item) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        DeviceRequestBuilder builder = new DeviceRequestBuilder(item);
        if (index < 0 || index >= this.requests.size()) {
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        } else {
            this._visitables.get("requests").add(index, builder);
            this.requests.add(index, builder);
        }
        return (A)this;
    }

    public A setToRequests(int index, DeviceRequest item) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        DeviceRequestBuilder builder = new DeviceRequestBuilder(item);
        if (index < 0 || index >= this.requests.size()) {
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        } else {
            this._visitables.get("requests").set(index, builder);
            this.requests.set(index, builder);
        }
        return (A)this;
    }

    public A addToRequests(DeviceRequest ... items) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        for (DeviceRequest item : items) {
            DeviceRequestBuilder builder = new DeviceRequestBuilder(item);
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        }
        return (A)this;
    }

    public A addAllToRequests(Collection<DeviceRequest> items) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        for (DeviceRequest item : items) {
            DeviceRequestBuilder builder = new DeviceRequestBuilder(item);
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        }
        return (A)this;
    }

    public A removeFromRequests(DeviceRequest ... items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (DeviceRequest item : items) {
            DeviceRequestBuilder builder = new DeviceRequestBuilder(item);
            this._visitables.get("requests").remove(builder);
            this.requests.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRequests(Collection<DeviceRequest> items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (DeviceRequest item : items) {
            DeviceRequestBuilder builder = new DeviceRequestBuilder(item);
            this._visitables.get("requests").remove(builder);
            this.requests.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRequests(Predicate<DeviceRequestBuilder> predicate) {
        if (this.requests == null) {
            return (A)this;
        }
        Iterator<DeviceRequestBuilder> each = this.requests.iterator();
        Object visitables = this._visitables.get("requests");
        while (each.hasNext()) {
            DeviceRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceRequest> buildRequests() {
        return this.requests != null ? DeviceClaimFluent.build(this.requests) : null;
    }

    public DeviceRequest buildRequest(int index) {
        return this.requests.get(index).build();
    }

    public DeviceRequest buildFirstRequest() {
        return this.requests.get(0).build();
    }

    public DeviceRequest buildLastRequest() {
        return this.requests.get(this.requests.size() - 1).build();
    }

    public DeviceRequest buildMatchingRequest(Predicate<DeviceRequestBuilder> predicate) {
        for (DeviceRequestBuilder item : this.requests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRequest(Predicate<DeviceRequestBuilder> predicate) {
        for (DeviceRequestBuilder item : this.requests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequests(List<DeviceRequest> requests) {
        if (this.requests != null) {
            this._visitables.get("requests").clear();
        }
        if (requests != null) {
            this.requests = new ArrayList();
            for (DeviceRequest item : requests) {
                this.addToRequests(item);
            }
        } else {
            this.requests = null;
        }
        return (A)this;
    }

    public A withRequests(DeviceRequest ... requests) {
        if (this.requests != null) {
            this.requests.clear();
            this._visitables.remove("requests");
        }
        if (requests != null) {
            for (DeviceRequest item : requests) {
                this.addToRequests(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequests() {
        return this.requests != null && !this.requests.isEmpty();
    }

    public RequestsNested<A> addNewRequest() {
        return new RequestsNested(-1, null);
    }

    public RequestsNested<A> addNewRequestLike(DeviceRequest item) {
        return new RequestsNested(-1, item);
    }

    public RequestsNested<A> setNewRequestLike(int index, DeviceRequest item) {
        return new RequestsNested(index, item);
    }

    public RequestsNested<A> editRequest(int index) {
        if (this.requests.size() <= index) {
            throw new RuntimeException("Can't edit requests. Index exceeds size.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestsNested<A> editFirstRequest() {
        if (this.requests.size() == 0) {
            throw new RuntimeException("Can't edit first requests. The list is empty.");
        }
        return this.setNewRequestLike(0, this.buildRequest(0));
    }

    public RequestsNested<A> editLastRequest() {
        int index = this.requests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last requests. The list is empty.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestsNested<A> editMatchingRequest(Predicate<DeviceRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requests.size(); ++i) {
            if (!predicate.test(this.requests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching requests. No match found.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceClaimFluent that = (DeviceClaimFluent)o;
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.constraints, that.constraints)) {
            return false;
        }
        if (!Objects.equals(this.requests, that.requests)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.config, this.constraints, this.requests, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.constraints != null && !this.constraints.isEmpty()) {
            sb.append("constraints:");
            sb.append(this.constraints + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RequestsNested<N>
    extends DeviceRequestFluent<RequestsNested<N>>
    implements Nested<N> {
        DeviceRequestBuilder builder;
        int index;

        RequestsNested(int index, DeviceRequest item) {
            this.index = index;
            this.builder = new DeviceRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceClaimFluent.this.setToRequests(this.index, this.builder.build());
        }

        public N endRequest() {
            return this.and();
        }
    }

    public class ConstraintsNested<N>
    extends DeviceConstraintFluent<ConstraintsNested<N>>
    implements Nested<N> {
        DeviceConstraintBuilder builder;
        int index;

        ConstraintsNested(int index, DeviceConstraint item) {
            this.index = index;
            this.builder = new DeviceConstraintBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceClaimFluent.this.setToConstraints(this.index, this.builder.build());
        }

        public N endConstraint() {
            return this.and();
        }
    }

    public class ConfigNested<N>
    extends DeviceClaimConfigurationFluent<ConfigNested<N>>
    implements Nested<N> {
        DeviceClaimConfigurationBuilder builder;
        int index;

        ConfigNested(int index, DeviceClaimConfiguration item) {
            this.index = index;
            this.builder = new DeviceClaimConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceClaimFluent.this.setToConfig(this.index, this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }
}

