/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.collector;

import io.fabric8.crd.generator.collector.CustomResourceClassLoader;
import io.fabric8.crd.generator.collector.JandexCustomResourceClassScanner;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.IndexView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResourceCollector {
    private static final Logger log = LoggerFactory.getLogger(CustomResourceCollector.class);
    private final CustomResourceClassLoader customResourceClassLoader;
    private final JandexCustomResourceClassScanner jandexCustomResourceClassScanner;
    private final Set<String> customResourceClassNames = new HashSet<String>();
    private final List<Predicate<String>> classNamePredicates = new LinkedList<Predicate<String>>();
    private boolean forceScan = false;

    public CustomResourceCollector() {
        this(null, null);
    }

    CustomResourceCollector(CustomResourceClassLoader customResourceClassLoader, JandexCustomResourceClassScanner jandexCustomResourceClassScanner) {
        this.customResourceClassLoader = Optional.ofNullable(customResourceClassLoader).orElseGet(CustomResourceClassLoader::new);
        this.jandexCustomResourceClassScanner = Optional.ofNullable(jandexCustomResourceClassScanner).orElseGet(JandexCustomResourceClassScanner::new);
    }

    public CustomResourceCollector withParentClassLoader(ClassLoader classLoader) {
        this.customResourceClassLoader.withParentClassLoader(classLoader);
        return this;
    }

    public CustomResourceCollector withClasspathElement(String ... classpathElement) {
        this.customResourceClassLoader.withClasspathElement(classpathElement);
        return this;
    }

    public CustomResourceCollector withClasspathElements(Collection<String> classpathElements) {
        this.customResourceClassLoader.withClasspathElements(classpathElements);
        return this;
    }

    public CustomResourceCollector withCustomResourceClass(String ... className) {
        if (className != null) {
            this.withCustomResourceClasses(Arrays.asList(className));
        }
        return this;
    }

    public CustomResourceCollector withCustomResourceClasses(Collection<String> classNames) {
        if (classNames != null) {
            classNames.stream().filter(Objects::nonNull).forEach(this.customResourceClassNames::add);
        }
        return this;
    }

    public CustomResourceCollector withIndex(IndexView ... index) {
        this.jandexCustomResourceClassScanner.withIndex(index);
        return this;
    }

    public CustomResourceCollector withIndices(Collection<IndexView> indices) {
        this.jandexCustomResourceClassScanner.withIndices(indices);
        return this;
    }

    public CustomResourceCollector withFileToScan(File ... files) {
        this.jandexCustomResourceClassScanner.withFileToScan(files);
        return this;
    }

    public CustomResourceCollector withFilesToScan(Collection<File> files) {
        this.jandexCustomResourceClassScanner.withFilesToScan(files);
        return this;
    }

    public CustomResourceCollector withForceIndex(boolean forceIndex) {
        this.jandexCustomResourceClassScanner.withForceIndex(forceIndex);
        return this;
    }

    public CustomResourceCollector withForceScan(boolean forceScan) {
        this.forceScan = forceScan;
        return this;
    }

    public CustomResourceCollector withIncludePackages(Collection<String> packages) {
        if (packages != null) {
            packages.stream().filter(Objects::nonNull).map(pkg -> s -> s.startsWith((String)pkg)).reduce(Predicate::or).ifPresent(this.classNamePredicates::add);
        }
        return this;
    }

    public CustomResourceCollector withExcludePackages(Collection<String> packages) {
        if (packages != null) {
            packages.stream().filter(Objects::nonNull).map(pkg -> s -> !s.startsWith((String)pkg)).reduce(Predicate::or).ifPresent(this.classNamePredicates::add);
        }
        return this;
    }

    public List<Class<? extends HasMetadata>> findCustomResourceClasses() {
        HashSet<String> customResourcesClassNames = new HashSet<String>(this.customResourceClassNames);
        if (this.forceScan || customResourcesClassNames.isEmpty()) {
            customResourcesClassNames.addAll(this.jandexCustomResourceClassScanner.findCustomResourceClasses());
            log.debug("Found {} custom resource classes", (Object)customResourcesClassNames.size());
        } else {
            log.debug("Using explicit {} custom resource classes and skip scanning", (Object)customResourcesClassNames.size());
        }
        Predicate<String> classNamePredicate = this.classNamePredicates.stream().reduce(Predicate::and).orElse(className -> true);
        List<Class<? extends HasMetadata>> customResourceClasses = customResourcesClassNames.stream().filter(classNamePredicate).map(this.customResourceClassLoader::loadCustomResourceClass).collect(Collectors.toList());
        log.debug("Retained {} custom resource classes after filtering", (Object)customResourceClasses.size());
        return customResourceClasses;
    }

    void reset() {
        this.customResourceClassLoader.reset();
        this.jandexCustomResourceClassScanner.reset();
        this.customResourceClassNames.clear();
        this.classNamePredicates.clear();
        this.forceScan = false;
    }
}

