/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.cli;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

class LoggingConfiguration {
    private LoggingConfiguration() {
    }

    static void configureLogger(List<Boolean> verbose) {
        LoggingConfiguration.configureLogger(LoggingConfiguration.getBaseLogLevel(verbose));
    }

    private static void configureLogger(LogLevel baseLogLevel) {
        LoggingConfiguration.setLogLevel("io.fabric8.crd.generator.cli", baseLogLevel.toLog4jLevel());
        LoggingConfiguration.setLogLevel("io.fabric8.crd.generator.collector", baseLogLevel.toLog4jLevel());
        LoggingConfiguration.setLogLevel("io.fabric8.crdv2.generator", baseLogLevel.toLog4jLevel());
    }

    private static void setLogLevel(String packageName, Level level) {
        Configurator.setLevel(packageName, level);
    }

    static LogLevel getBaseLogLevel(List<Boolean> verbose) {
        switch (verbose.size()) {
            case 1: {
                return LogLevel.INFO;
            }
            case 2: {
                return LogLevel.DEBUG;
            }
        }
        if (verbose.size() >= 3) {
            return LogLevel.TRACE;
        }
        return LogLevel.WARN;
    }

    static enum LogLevel {
        WARN,
        INFO,
        DEBUG,
        TRACE;


        Level toLog4jLevel() {
            return Level.valueOf(this.name());
        }
    }
}

