/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Resources {
    private final KubernetesListBuilder global = new KubernetesListBuilder();
    private final Set<Decorator> globalDecorators = new TreeSet<Decorator>();

    public KubernetesListBuilder global() {
        return this.global;
    }

    protected Set<Decorator> getDecorators() {
        return this.globalDecorators;
    }

    public void decorate(Decorator decorator) {
        this.globalDecorators.add(decorator);
    }

    public void add(HasMetadata metadata) {
        this.global.addToItems(new HasMetadata[]{metadata});
    }

    public KubernetesList generate() {
        for (Decorator decorator : this.applyConstraints(this.globalDecorators)) {
            this.global.accept(new Visitor[]{decorator});
        }
        return this.global.build();
    }

    public List<Decorator> applyConstraints(Set<Decorator> decorators) {
        ArrayList<Decorator> result = new ArrayList<Decorator>();
        Decorator[] array = decorators.toArray(new Decorator[decorators.size()]);
        for (int i = 0; i < 10 && this.bubbleSort(array); ++i) {
            System.out.println("Sorting again:" + (i + 1));
        }
        for (Decorator d : array) {
            result.add(d);
        }
        return result;
    }

    private boolean bubbleSort(Decorator[] decorators) {
        boolean swapped = false;
        int n = decorators.length;
        Decorator temp = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 1; j < n - i; ++j) {
                if (decorators[j].compareTo(decorators[j - 1]) >= 0) continue;
                swapped = true;
                temp = decorators[j - 1];
                decorators[j - 1] = decorators[j];
                decorators[j] = temp;
            }
        }
        return swapped;
    }
}

