/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import io.fabric8.crd.generator.utils.Types;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.model.Scope;
import io.sundr.model.TypeDef;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResourceInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomResourceInfo.class);
    public static final boolean DESCRIBE_TYPE_DEFS = false;
    private final String group;
    private final String version;
    private final String kind;
    private final String singular;
    private final String plural;
    private final String[] shortNames;
    private final boolean storage;
    private final boolean served;
    private final Scope scope;
    private final TypeDef definition;
    private final String crClassName;
    private final String specClassName;
    private final String statusClassName;
    private final String id;
    private final int hash;
    private final String[] annotations;
    private final String[] labels;

    public CustomResourceInfo(String group, String version, String kind, String singular, String plural, String[] shortNames, boolean storage, boolean served, Scope scope, TypeDef definition, String crClassName, String specClassName, String statusClassName, String[] annotations, String[] labels) {
        this.group = group;
        this.version = version;
        this.kind = kind;
        this.singular = singular;
        this.plural = plural;
        this.shortNames = shortNames;
        this.storage = storage;
        this.served = served;
        this.scope = scope;
        this.definition = definition;
        this.crClassName = crClassName;
        this.specClassName = specClassName;
        this.statusClassName = statusClassName;
        this.id = this.crdName() + "/" + version;
        this.hash = this.id.hashCode();
        this.annotations = annotations;
        this.labels = labels;
    }

    public boolean storage() {
        return this.storage;
    }

    public boolean served() {
        return this.served;
    }

    public String key() {
        return this.crdName();
    }

    public Scope scope() {
        return this.scope;
    }

    public String crdName() {
        return this.plural() + "." + this.group;
    }

    public String[] shortNames() {
        return this.shortNames;
    }

    public String singular() {
        return this.singular;
    }

    public String plural() {
        return this.plural;
    }

    public String kind() {
        return this.kind;
    }

    public String version() {
        return this.version;
    }

    public String group() {
        return this.group;
    }

    public String crClassName() {
        return this.crClassName;
    }

    public Optional<String> specClassName() {
        return Optional.ofNullable(this.specClassName);
    }

    public Optional<String> statusClassName() {
        return Optional.ofNullable(this.statusClassName);
    }

    public TypeDef definition() {
        return this.definition;
    }

    public String[] annotations() {
        return this.annotations;
    }

    public String[] labels() {
        return this.labels;
    }

    public static CustomResourceInfo fromClass(Class<? extends CustomResource<?, ?>> customResource) {
        try {
            CustomResource<?, ?> instance = customResource.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String[] shortNames = CustomResource.getShortNames(customResource);
            TypeDef definition = Types.typeDefFrom(customResource);
            Scope scope = Types.isNamespaced(definition) ? Scope.NAMESPACED : Scope.CLUSTER;
            Types.SpecAndStatus specAndStatus = Types.resolveSpecAndStatusTypes(definition);
            if (specAndStatus.isUnreliable()) {
                LOGGER.warn("Cannot reliably determine status types for {} because it isn't parameterized with only spec and status types. Status replicas detection will be deactivated.", (Object)customResource.getCanonicalName());
            }
            return new CustomResourceInfo(instance.getGroup(), instance.getVersion(), instance.getKind(), instance.getSingular(), instance.getPlural(), shortNames, instance.isStorage(), instance.isServed(), scope, definition, customResource.getCanonicalName(), specAndStatus.getSpecClassName(), specAndStatus.getStatusClassName(), CustomResourceInfo.toStringArray(instance.getMetadata().getAnnotations()), CustomResourceInfo.toStringArray(instance.getMetadata().getLabels()));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public static String[] toStringArray(Map<String, String> map) {
        String[] res = new String[map.size()];
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        int i = 0;
        for (Map.Entry<String, String> e : entrySet) {
            res[i] = e.getKey() + "=" + e.getValue();
            ++i;
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceInfo that = (CustomResourceInfo)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.hash;
    }
}

