/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import io.fabric8.crd.generator.AbstractJsonSchema;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.crd.generator.Resources;
import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.visitor.AdditionalPrinterColumnDetector;
import io.fabric8.crd.generator.visitor.ClassDependenciesVisitor;
import io.fabric8.crd.generator.visitor.LabelSelectorPathDetector;
import io.fabric8.crd.generator.visitor.SpecReplicasPathDetector;
import io.fabric8.crd.generator.visitor.StatusReplicasPathDetector;
import io.fabric8.kubernetes.client.utils.Utils;
import io.sundr.builder.Visitor;
import io.sundr.model.AnnotationRef;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public abstract class AbstractCustomResourceHandler {
    protected final Resources resources;
    private final boolean parallel;

    protected AbstractCustomResourceHandler(Resources resources, boolean parallel) {
        this.resources = resources;
        this.parallel = parallel;
    }

    public void handle(CustomResourceInfo config) {
        String name = config.crdName();
        String version = config.version();
        TypeDef def = config.definition();
        SpecReplicasPathDetector specReplicasPathDetector = new SpecReplicasPathDetector();
        StatusReplicasPathDetector statusReplicasPathDetector = new StatusReplicasPathDetector();
        LabelSelectorPathDetector labelSelectorPathDetector = new LabelSelectorPathDetector();
        AdditionalPrinterColumnDetector additionalPrinterColumnDetector = new AdditionalPrinterColumnDetector();
        ClassDependenciesVisitor traversedClassesVisitor = new ClassDependenciesVisitor(config.crClassName(), name);
        ArrayList<Visitor<TypeDefBuilder>> visitors = new ArrayList<Visitor<TypeDefBuilder>>();
        if (config.specClassName().isPresent()) {
            visitors.add((Visitor<TypeDefBuilder>)specReplicasPathDetector);
        }
        if (config.statusClassName().isPresent()) {
            visitors.add((Visitor<TypeDefBuilder>)statusReplicasPathDetector);
        }
        visitors.add((Visitor<TypeDefBuilder>)labelSelectorPathDetector);
        visitors.add((Visitor<TypeDefBuilder>)additionalPrinterColumnDetector);
        visitors.add((Visitor<TypeDefBuilder>)traversedClassesVisitor);
        this.visitTypeDef(def, visitors);
        this.addDecorators(config, def, specReplicasPathDetector.getPath(), statusReplicasPathDetector.getPath(), labelSelectorPathDetector.getPath());
        HashMap<String, Property> additionalPrinterColumns = new HashMap<String, Property>(additionalPrinterColumnDetector.getProperties());
        additionalPrinterColumns.forEach((path, property) -> {
            Map parameters = property.getAnnotations().stream().filter(a -> a.getClassRef().getName().equals("PrinterColumn")).map(AnnotationRef::getParameters).findFirst().orElse(Collections.emptyMap());
            String type = AbstractJsonSchema.getSchemaTypeFor(property.getTypeRef());
            String column = (String)parameters.get("name");
            if (Utils.isNullOrEmpty((String)column)) {
                column = property.getName().toUpperCase();
            }
            String description = property.getComments().stream().filter(l -> !l.trim().startsWith("@")).collect(Collectors.joining(" ")).trim();
            String format = (String)parameters.get("format");
            this.resources.decorate(this.getPrinterColumnDecorator(name, version, (String)path, type, column, description, format));
        });
    }

    private TypeDef visitTypeDef(TypeDef def, List<Visitor<TypeDefBuilder>> visitors) {
        if (visitors.isEmpty()) {
            return def;
        }
        if (this.parallel) {
            return this.visitTypeDefInParallel(def, visitors);
        }
        return this.visitTypeDefSequentially(def, visitors);
    }

    private TypeDef visitTypeDefSequentially(TypeDef def, List<Visitor<TypeDefBuilder>> visitors) {
        TypeDefBuilder builder = new TypeDefBuilder(def);
        for (Visitor<TypeDefBuilder> visitor : visitors) {
            builder.accept(new Visitor[]{visitor});
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeDef visitTypeDefInParallel(TypeDef def, List<Visitor<TypeDefBuilder>> visitors) {
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(visitors.size(), Runtime.getRuntime().availableProcessors()));
        try {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (Visitor<TypeDefBuilder> visitor : visitors) {
                futures.add(CompletableFuture.runAsync(() -> {
                    TypeDefBuilder builder = new TypeDefBuilder(def);
                    builder.accept(new Visitor[]{visitor});
                }, executorService));
            }
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new RuntimeException(ex.getCause());
            }
        }
        finally {
            executorService.shutdown();
        }
        return def;
    }

    protected abstract Decorator getPrinterColumnDecorator(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    protected abstract void addDecorators(CustomResourceInfo var1, TypeDef var2, Optional<String> var3, Optional<String> var4, Optional<String> var5);
}

