/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import io.fabric8.crd.generator.AbstractJsonSchema;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.crd.generator.Resources;
import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.utils.Types;
import io.fabric8.crd.generator.visitor.AdditionalPrinterColumnDetector;
import io.fabric8.crd.generator.visitor.LabelSelectorPathDetector;
import io.fabric8.crd.generator.visitor.SpecReplicasPathDetector;
import io.fabric8.crd.generator.visitor.StatusReplicasPathDetector;
import io.fabric8.kubernetes.client.utils.Utils;
import io.sundr.builder.Visitor;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeDefFluent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractCustomResourceHandler {
    protected final Resources resources;

    protected AbstractCustomResourceHandler(Resources resources) {
        this.resources = resources;
    }

    public void handle(CustomResourceInfo config) {
        String name = config.crdName();
        String version = config.version();
        TypeDef def = config.definition();
        SpecReplicasPathDetector specReplicasPathDetector = new SpecReplicasPathDetector();
        StatusReplicasPathDetector statusReplicasPathDetector = new StatusReplicasPathDetector();
        LabelSelectorPathDetector labelSelectorPathDetector = new LabelSelectorPathDetector();
        AdditionalPrinterColumnDetector additionalPrinterColumnDetector = new AdditionalPrinterColumnDetector();
        TypeDefBuilder builder = new TypeDefBuilder(def);
        Optional<Property> statusProperty = Types.findStatusProperty(def);
        if (statusProperty.isPresent()) {
            Property p = statusProperty.get();
            builder.removeFromProperties(new Property[]{p});
            def = ((TypeDefBuilder)((TypeDefFluent.PropertiesNested)((TypeDefFluent.PropertiesNested)builder.addNewProperty().withName("status")).withTypeRef(p.getTypeRef())).endProperty()).build();
        }
        def = ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(def).accept(new Visitor[]{specReplicasPathDetector})).accept(new Visitor[]{statusReplicasPathDetector})).accept(new Visitor[]{labelSelectorPathDetector})).accept(new Visitor[]{additionalPrinterColumnDetector})).build();
        this.addDecorators(config, def, specReplicasPathDetector.getPath(), statusReplicasPathDetector.getPath(), labelSelectorPathDetector.getPath());
        HashMap<String, Property> additionalPrinterColumns = new HashMap<String, Property>();
        additionalPrinterColumns.putAll(additionalPrinterColumnDetector.getProperties());
        additionalPrinterColumns.forEach((path, property) -> {
            Map parameters = property.getAnnotations().stream().filter(a -> a.getClassRef().getName().equals("PrinterColumn")).map(a -> a.getParameters()).findFirst().orElse(Collections.emptyMap());
            String type = AbstractJsonSchema.COMMON_MAPPINGS.getOrDefault(property.getTypeRef(), "object");
            String column = (String)parameters.get("name");
            if (Utils.isNullOrEmpty((String)column)) {
                column = property.getName().toUpperCase();
            }
            String description = property.getComments().stream().filter(l -> !l.trim().startsWith("@")).collect(Collectors.joining(" ")).trim();
            String format = (String)parameters.get("format");
            this.resources.decorate(this.getPrinterColumnDecorator(name, version, (String)path, type, column, description, format));
        });
    }

    protected abstract Decorator getPrinterColumnDecorator(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    protected abstract void addDecorators(CustomResourceInfo var1, TypeDef var2, Optional<String> var3, Optional<String> var4, Optional<String> var5);
}

