/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import io.fabric8.crdv2.generator.CRDInfo;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CRDGenerationInfo {
    static final CRDGenerationInfo EMPTY = new CRDGenerationInfo();
    private final Map<String, Map<String, CRDInfo>> crdNameToVersionToCRDInfoMap = new HashMap<String, Map<String, CRDInfo>>();

    public Map<String, CRDInfo> getCRDInfos(String crdName) {
        return this.crdNameToVersionToCRDInfoMap.get(crdName);
    }

    public Map<String, Map<String, CRDInfo>> getCRDDetailsPerNameAndVersion() {
        return this.crdNameToVersionToCRDInfoMap;
    }

    void add(String crdName, String version, URI fileURI, Set<String> dependentClassNames) {
        this.crdNameToVersionToCRDInfoMap.computeIfAbsent(crdName, k -> new HashMap()).put(version, new CRDInfo(crdName, version, new File(fileURI).getAbsolutePath(), dependentClassNames));
    }

    public int numberOfGeneratedCRDs() {
        return this.crdNameToVersionToCRDInfoMap.values().stream().map(Map::size).reduce(Integer::sum).orElse(0);
    }
}

