/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.domain;

import io.eventuate.AggregateRepository;
import io.eventuate.Command;
import io.eventuate.CommandProcessingAggregate;
import io.eventuate.DispatchedEvent;
import io.eventuate.EntityWithIdAndVersion;
import io.eventuate.Event;
import io.eventuate.EventContext;
import io.eventuate.EventHandlerContext;
import io.eventuate.EventuateAggregateStoreCrud;
import io.eventuate.SaveOptions;
import io.eventuate.UpdateOptions;
import io.eventuate.common.id.Int128;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class EventHandlerContextImpl
implements EventHandlerContext<Event> {
    private EventuateAggregateStoreCrud aggregateStore;
    private final DispatchedEvent<Event> de;

    public EventHandlerContextImpl(EventuateAggregateStoreCrud aggregateStore, DispatchedEvent<Event> de) {
        this.aggregateStore = aggregateStore;
        this.de = de;
    }

    public Event getEvent() {
        return this.de.getEvent();
    }

    public Int128 getEventId() {
        return this.de.getEventId();
    }

    public Class<Event> getEventType() {
        return this.de.getEventType();
    }

    public String getEntityId() {
        return this.de.getEntityId();
    }

    public Integer getSwimlane() {
        return this.de.getSwimlane();
    }

    public Long getOffset() {
        return this.de.getOffset();
    }

    public EventContext getEventContext() {
        return this.de.getEventContext();
    }

    public Optional<Map<String, String>> getEventMetadata() {
        return this.de.getEventMetadata();
    }

    public <U extends CommandProcessingAggregate<U, CT>, CT extends Command> CompletableFuture<EntityWithIdAndVersion<U>> save(Class<U> entityClass, CT command, Optional<String> entityId) {
        AggregateRepository ar = new AggregateRepository(entityClass, this.aggregateStore);
        return ar.save(command, Optional.of(new SaveOptions().withId(entityId).withEventContext(this.de.getEventContext())));
    }

    public <U extends CommandProcessingAggregate<U, CT>, CT extends Command> CompletableFuture<EntityWithIdAndVersion<U>> update(Class<U> entityClass, String entityId, CT command) {
        AggregateRepository ar = new AggregateRepository(entityClass, this.aggregateStore);
        return ar.update(entityId, command, Optional.of(new UpdateOptions().withTriggeringEvent(this.de.getEventContext())));
    }

    public <A extends CommandProcessingAggregate<A, CT>, CT extends Command> CompletableFuture<EntityWithIdAndVersion<A>> updateWithProvidedCommand(Class<A> entityClass, String entityId, Function<A, Optional<CT>> commandProvider) {
        AggregateRepository ar = new AggregateRepository(entityClass, this.aggregateStore);
        return ar.updateWithProvidedCommand(entityId, commandProvider, Optional.of(new UpdateOptions().withTriggeringEvent(this.de.getEventContext())));
    }
}

