/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.Future;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.MappingLookup;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class MappingResolver<A extends Address, B>
implements EndpointResolver<A, SocketAddress, MappingLookup<A, B>, B> {
    private final Function<A, List<SocketAddress>> serviceMap;

    public MappingResolver(Function<A, List<SocketAddress>> serviceMap) {
        this.serviceMap = Objects.requireNonNull(serviceMap);
    }

    @Override
    public A tryCast(Address address) {
        return (A)address;
    }

    @Override
    public SocketAddress addressOf(SocketAddress server) {
        return server;
    }

    @Override
    public Future<MappingLookup<A, B>> resolve(A address, EndpointBuilder<B, SocketAddress> builder) {
        return Future.succeededFuture(new MappingLookup<A, B>(address, builder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public B endpoint(MappingLookup<A, B> state) {
        List<SocketAddress> endpoints = this.serviceMap.apply(state.address);
        MappingLookup<A, B> mappingLookup = state;
        synchronized (mappingLookup) {
            if (!Objects.equals(state.endpoints, endpoints)) {
                EndpointBuilder builder = state.builder;
                if (endpoints != null) {
                    for (SocketAddress address : endpoints) {
                        builder = builder.addServer(address);
                    }
                }
                state.endpoints = endpoints;
                state.list = builder.build();
            }
            return state.list;
        }
    }

    @Override
    public boolean isValid(MappingLookup<A, B> state) {
        return true;
    }

    @Override
    public void dispose(MappingLookup<A, B> data) {
    }

    @Override
    public void close() {
    }
}

