/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetworkOptions;
import java.util.Map;

public class NetworkOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetworkOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "sendBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSendBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "receiveBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReceiveBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "reuseAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReuseAddress((Boolean)member.getValue());
                    break;
                }
                case "trafficClass": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTrafficClass(((Number)member.getValue()).intValue());
                    break;
                }
                case "logActivity": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setLogActivity((Boolean)member.getValue());
                    break;
                }
                case "activityLogDataFormat": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setActivityLogDataFormat(ByteBufFormat.valueOf((String)member.getValue()));
                    break;
                }
                case "reusePort": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReusePort((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetworkOptions obj, JsonObject json) {
        NetworkOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(NetworkOptions obj, Map<String, Object> json) {
        json.put("sendBufferSize", obj.getSendBufferSize());
        json.put("receiveBufferSize", obj.getReceiveBufferSize());
        json.put("reuseAddress", obj.isReuseAddress());
        json.put("trafficClass", obj.getTrafficClass());
        json.put("logActivity", obj.getLogActivity());
        if (obj.getActivityLogDataFormat() != null) {
            json.put("activityLogDataFormat", obj.getActivityLogDataFormat().name());
        }
        json.put("reusePort", obj.isReusePort());
    }
}

