/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.net;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.ImmediateExecutor;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.VertxSniHandler;
import io.vertx.core.internal.tls.SslContextProvider;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SslChannelProvider {
    private final Executor workerPool;
    private final boolean sni;
    private final SslContextProvider sslContextProvider;

    public SslChannelProvider(VertxInternal vertx, SslContextProvider sslContextProvider, boolean sni) {
        this.workerPool = vertx.internalWorkerPool().executor();
        this.sni = sni;
        this.sslContextProvider = sslContextProvider;
    }

    public SslContextProvider sslContextProvider() {
        return this.sslContextProvider;
    }

    public SslHandler createClientSslHandler(SocketAddress peerAddress, String serverName, boolean useAlpn, long sslHandshakeTimeout, TimeUnit sslHandshakeTimeoutUnit) {
        SslContext sslContext = this.sslContextProvider.sslClientContext(serverName, useAlpn);
        Executor delegatedTaskExec = this.sslContextProvider.useWorkerPool() ? this.workerPool : ImmediateExecutor.INSTANCE;
        SslHandler sslHandler = peerAddress != null && peerAddress.isInetSocket() ? sslContext.newHandler(ByteBufAllocator.DEFAULT, peerAddress.host(), peerAddress.port(), delegatedTaskExec) : sslContext.newHandler(ByteBufAllocator.DEFAULT, delegatedTaskExec);
        sslHandler.setHandshakeTimeout(sslHandshakeTimeout, sslHandshakeTimeoutUnit);
        return sslHandler;
    }

    public ChannelHandler createServerHandler(boolean useAlpn, long sslHandshakeTimeout, TimeUnit sslHandshakeTimeoutUnit, HostAndPort remoteAddress) {
        if (this.sni) {
            return this.createSniHandler(useAlpn, sslHandshakeTimeout, sslHandshakeTimeoutUnit, remoteAddress);
        }
        return this.createServerSslHandler(useAlpn, sslHandshakeTimeout, sslHandshakeTimeoutUnit, remoteAddress);
    }

    private SslHandler createServerSslHandler(boolean useAlpn, long sslHandshakeTimeout, TimeUnit sslHandshakeTimeoutUnit, HostAndPort remoteAddress) {
        SslContext sslContext = this.sslContextProvider.sslServerContext(useAlpn);
        Executor delegatedTaskExec = this.sslContextProvider.useWorkerPool() ? this.workerPool : ImmediateExecutor.INSTANCE;
        SslHandler sslHandler = remoteAddress != null ? sslContext.newHandler(ByteBufAllocator.DEFAULT, remoteAddress.host(), remoteAddress.port(), delegatedTaskExec) : sslContext.newHandler(ByteBufAllocator.DEFAULT, delegatedTaskExec);
        sslHandler.setHandshakeTimeout(sslHandshakeTimeout, sslHandshakeTimeoutUnit);
        return sslHandler;
    }

    private SniHandler createSniHandler(boolean useAlpn, long sslHandshakeTimeout, TimeUnit sslHandshakeTimeoutUnit, HostAndPort remoteAddress) {
        Executor delegatedTaskExec = this.sslContextProvider.useWorkerPool() ? this.workerPool : ImmediateExecutor.INSTANCE;
        return new VertxSniHandler(this.sslContextProvider.serverNameMapping(delegatedTaskExec, useAlpn), sslHandshakeTimeoutUnit.toMillis(sslHandshakeTimeout), delegatedTaskExec, remoteAddress);
    }
}

