/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

final class NettyFileUpload
implements FileUpload,
ReadStream<Buffer> {
    private final String name;
    private String contentType;
    private String filename;
    private String contentTransferEncoding;
    private Charset charset;
    private boolean completed;
    private long maxSize = -1L;
    private final HttpServerRequest request;
    private final InboundBuffer<Object> pending;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private final long size;

    NettyFileUpload(Context context, HttpServerRequest request, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
        this.request = request;
        this.size = size;
        this.pending = new InboundBuffer(context).drainHandler(v -> request.resume()).handler((E buff) -> {
            if (buff == InboundBuffer.END_SENTINEL) {
                Handler<Void> handler = this.endHandler();
                if (handler != null) {
                    handler.handle(null);
                }
            } else {
                Handler<Buffer> handler = this.handler();
                if (handler != null) {
                    handler.handle((Buffer)buff);
                }
            }
        });
    }

    @Override
    public synchronized NettyFileUpload exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private Handler<Buffer> handler() {
        return this.dataHandler;
    }

    public synchronized NettyFileUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    public NettyFileUpload pause() {
        this.pending.pause();
        return this;
    }

    public NettyFileUpload resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    public NettyFileUpload fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    private synchronized Handler<Void> endHandler() {
        return this.endHandler;
    }

    public synchronized NettyFileUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    private void receiveData(Buffer data) {
        if (data.length() != 0 && !this.pending.write(data)) {
            this.request.pause();
        }
    }

    private void end() {
        this.pending.write(InboundBuffer.END_SENTINEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Throwable err) {
        Handler<Throwable> handler;
        NettyFileUpload nettyFileUpload = this;
        synchronized (nettyFileUpload) {
            handler = this.exceptionHandler;
        }
        if (handler != null) {
            handler.handle(err);
        }
    }

    @Override
    public void setContent(ByteBuf channelBuffer) throws IOException {
        this.completed = true;
        this.receiveData(BufferInternal.buffer(channelBuffer));
        this.end();
    }

    @Override
    public void addContent(ByteBuf channelBuffer, boolean last) throws IOException {
        this.receiveData(BufferInternal.buffer(channelBuffer));
        if (last) {
            this.completed = true;
            this.end();
        }
    }

    @Override
    public void setContent(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContent(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long definedLength() {
        return this.size;
    }

    @Override
    public void checkSize(long newSize) throws IOException {
        if (this.maxSize >= 0L && newSize > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public byte[] get() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getChunk(int i) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Charset charset) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean renameTo(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public File getFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(InterfaceHttpData o) {
        return 0;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    @Override
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public ByteBuf getByteBuf() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload duplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload retainedDuplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload replace(ByteBuf content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload retain() {
        return this;
    }

    @Override
    public FileUpload retain(int increment) {
        return this;
    }

    @Override
    public FileUpload touch(Object hint) {
        return this;
    }

    @Override
    public FileUpload touch() {
        return this;
    }

    @Override
    public ByteBuf content() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int refCnt() {
        return 1;
    }

    @Override
    public boolean release() {
        return false;
    }

    @Override
    public boolean release(int decrement) {
        return false;
    }
}

