/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.MimeMapping;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.CookieJar;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.HttpNetSocket;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.streams.ReadStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;

public class Http2ServerResponse
implements HttpServerResponse,
HttpResponse {
    private final Http2ServerStream stream;
    private final ChannelHandlerContext ctx;
    private final Http2ServerConnection conn;
    private final boolean push;
    private final Http2Headers headers = new DefaultHttp2Headers();
    private Http2HeadersAdaptor headersMap;
    private Http2Headers trailers;
    private Http2HeadersAdaptor trailedMap;
    private boolean chunked;
    private boolean headWritten;
    private boolean ended;
    private boolean closed;
    private CookieJar cookies;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private String statusMessage;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Future<NetSocket> netSocket;

    public Http2ServerResponse(Http2ServerConnection conn, Http2ServerStream stream, boolean push) {
        this.stream = stream;
        this.ctx = conn.handlerContext;
        this.conn = conn;
        this.push = push;
    }

    boolean isPush() {
        return this.push;
    }

    void handleReset(long code) {
        this.handleException(new StreamResetException(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable cause) {
        Handler<Throwable> handler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.ended) {
                return;
            }
            handler = this.exceptionHandler;
        }
        if (handler != null) {
            handler.handle(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClose() {
        Handler<Void> closeHandler;
        Handler<Void> endHandler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.closed = true;
            boolean failed = !this.ended;
            endHandler = failed ? this.endHandler : null;
            closeHandler = this.closeHandler;
        }
        if (endHandler != null) {
            this.stream.context.emit(null, endHandler);
        }
        if (closeHandler != null) {
            this.stream.context.emit(null, closeHandler);
        }
    }

    private void checkHeadWritten() {
        if (this.headWritten) {
            throw new IllegalStateException("Response head already sent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    @Override
    public int statusCode() {
        return this.getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStatusCode() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.status.code();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        if (statusCode < 0) {
            throw new IllegalArgumentException("code: " + statusCode + " (expected: 0+)");
        }
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.status = HttpResponseStatus.valueOf(statusCode);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatusMessage() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.statusMessage == null) {
                return this.status.reasonPhrase();
            }
            return this.statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.statusMessage = statusMessage;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setChunked(boolean chunked) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.chunked = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.chunked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.headersMap == null) {
                this.headersMap = new Http2HeadersAdaptor(this.headers);
            }
            return this.headersMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.trailedMap == null) {
                this.trailers = new DefaultHttp2Headers();
                this.trailedMap = new Http2HeadersAdaptor(this.trailers);
            }
            return this.trailedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeContinue() {
        PromiseInternal<Void> promise = this.stream.context.promise();
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.stream.writeHeaders(new DefaultHttp2Headers().status(HttpResponseStatus.CONTINUE.codeAsText()), true, false, true, promise);
        }
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeHead() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
        }
        return this.checkSendHeaders(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeEarlyHints(MultiMap headers) {
        PromiseInternal<Void> promise = this.stream.context.promise();
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
        for (Map.Entry header : headers) {
            http2Headers.add((CharSequence)header.getKey(), (CharSequence)header.getValue());
        }
        http2Headers.status(HttpResponseStatus.EARLY_HINTS.codeAsText());
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
        }
        this.stream.writeHeaders(http2Headers, true, false, true, promise);
        return promise.future();
    }

    @Override
    public Future<Void> write(Buffer chunk) {
        ByteBuf buf = ((BufferInternal)chunk).getByteBuf();
        return this.write(buf, false);
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        return this.write(BufferInternal.buffer(chunk, enc).getByteBuf(), false);
    }

    @Override
    public Future<Void> write(String chunk) {
        return this.write(BufferInternal.buffer(chunk).getByteBuf(), false);
    }

    @Override
    public Future<Void> end(String chunk) {
        return this.end(Buffer.buffer(chunk));
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        return this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        return this.write(((BufferInternal)chunk).getByteBuf(), true);
    }

    @Override
    public Future<Void> end() {
        return this.write(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<NetSocket> netSocket() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.netSocket == null) {
                this.status = HttpResponseStatus.OK;
                if (this.checkSendHeaders(false) == null) {
                    this.netSocket = this.stream.context.failedFuture("Response for CONNECT already sent");
                } else {
                    HttpNetSocket ns = HttpNetSocket.netSocket(this.conn, this.stream.context, (ReadStream)((Object)this.stream.request), this);
                    this.netSocket = Future.succeededFuture(ns);
                }
            }
        }
        return this.netSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Void> write(ByteBuf chunk, boolean end) {
        Handler<Void> endHandler;
        Handler<Void> bodyEndHandler;
        Future<Void> fut;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            boolean sent;
            if (this.ended) {
                throw new IllegalStateException("Response has already been written");
            }
            this.ended = end;
            boolean hasBody = false;
            if (chunk != null) {
                hasBody = true;
            } else {
                chunk = Unpooled.EMPTY_BUFFER;
            }
            if (end && !this.headWritten && this.needsContentLengthHeader()) {
                this.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)HttpUtils.positiveLongToString(chunk.readableBytes()));
            }
            boolean bl = sent = this.checkSendHeaders(end && !hasBody && this.trailers == null, !hasBody) != null;
            if (hasBody || !sent && end) {
                PromiseInternal<Void> p = this.stream.context.promise();
                fut = p.future();
                this.stream.writeData(chunk, end && this.trailers == null, p);
            } else {
                fut = this.stream.context.succeededFuture();
            }
            if (end && this.trailers != null) {
                this.stream.writeHeaders(this.trailers, false, true, true, null);
            }
            bodyEndHandler = this.bodyEndHandler;
            endHandler = this.endHandler;
        }
        if (end) {
            if (bodyEndHandler != null) {
                bodyEndHandler.handle(null);
            }
            if (endHandler != null) {
                endHandler.handle(null);
            }
        }
        return fut;
    }

    private boolean needsContentLengthHeader() {
        return this.stream.method != HttpMethod.HEAD && this.status != HttpResponseStatus.NOT_MODIFIED && !this.headers.contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    private Future<Void> checkSendHeaders(boolean end) {
        return this.checkSendHeaders(end, true);
    }

    private Future<Void> checkSendHeaders(boolean end, boolean checkFlush) {
        if (!this.headWritten) {
            if (this.headersEndHandler != null) {
                this.headersEndHandler.handle(null);
            }
            if (this.cookies != null) {
                this.setCookies();
            }
            this.prepareHeaders();
            this.headWritten = true;
            PromiseInternal<Void> promise = this.stream.context.promise();
            this.stream.writeHeaders(this.headers, true, end, checkFlush, promise);
            return promise.future();
        }
        return null;
    }

    private void prepareHeaders() {
        this.headers.status(this.status.codeAsText());
        if (this.stream.method == HttpMethod.HEAD || this.status == HttpResponseStatus.NOT_MODIFIED) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
        } else if (this.status == HttpResponseStatus.RESET_CONTENT) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
            this.headers.set(HttpHeaders.CONTENT_LENGTH, "0");
        } else if (this.status.codeClass() == HttpStatusClass.INFORMATIONAL || this.status == HttpResponseStatus.NO_CONTENT) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
            this.headers.remove(HttpHeaders.CONTENT_LENGTH);
        }
    }

    private void setCookies() {
        for (ServerCookie cookie : this.cookies) {
            if (!cookie.isChanged()) continue;
            this.headers.add(HttpHeaders.SET_COOKIE, cookie.encode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeCustomFrame(int type, int flags, Buffer payload) {
        PromiseInternal<Void> promise = this.stream.context.promise();
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.checkSendHeaders(false);
            this.stream.writeFrame(type, flags, ((BufferInternal)payload).getByteBuf(), promise);
        }
        return promise.future();
    }

    private void checkValid() {
        if (this.ended) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWriteQueueDrained() {
        Handler<Void> handler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            handler = this.drainHandler;
            if (this.ended || handler == null) {
                return;
            }
        }
        handler.handle(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            return this.stream.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.drainHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        if (offset < 0L) {
            return this.stream.context.failedFuture("offset : " + offset + " (expected: >= 0)");
        }
        if (length < 0L) {
            return this.stream.context.failedFuture("length : " + length + " (expected: >= 0)");
        }
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
        }
        return HttpUtils.resolveFile(this.stream.context, filename, offset, length).compose(file -> {
            String contentType;
            long fileLength = file.getReadLength();
            long contentLength = Math.min(length, fileLength);
            if (this.headers.get(HttpHeaderNames.CONTENT_LENGTH) == null) {
                this.putHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)HttpUtils.positiveLongToString(contentLength));
            }
            if (this.headers.get(HttpHeaderNames.CONTENT_TYPE) == null && (contentType = MimeMapping.mimeTypeForFilename(filename)) != null) {
                this.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType);
            }
            this.checkSendHeaders(false);
            Future<Void> fut = file.pipeTo(this);
            return fut.eventually(file::close);
        });
    }

    @Override
    public Future<Void> sendFile(RandomAccessFile file, long offset, long length) {
        return this.stream.context.failedFuture("HTTP/2 does not support sending random access file for now");
    }

    @Override
    public Future<Void> sendFile(FileChannel channel, long offset, long length) {
        return this.stream.context.failedFuture("HTTP/2 does not support sending channel for now");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean closed() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    @Override
    public long bytesWritten() {
        return this.stream.bytesWritten();
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    @Override
    public Future<Void> reset(long code) {
        return this.stream.writeReset(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<HttpServerResponse> push(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        if (this.push) {
            throw new IllegalStateException("A push response cannot promise another push");
        }
        if (authority == null) {
            authority = this.stream.authority();
        }
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
        }
        PromiseInternal<HttpServerResponse> promise = this.stream.context.promise();
        this.conn.sendPush(this.stream.id(), authority, method, headers, path, this.stream.priority(), promise);
        return promise.future();
    }

    @Override
    public HttpServerResponse setStreamPriority(StreamPriority priority) {
        this.stream.updatePriority(priority);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CookieJar cookies() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.cookies == null) {
                CharSequence cookieHeader = this.stream.headers != null ? (CharSequence)this.stream.headers.get(HttpHeaders.COOKIE) : null;
                this.cookies = cookieHeader == null ? new CookieJar() : new CookieJar(cookieHeader);
            }
        }
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.cookies().add((ServerCookie)cookie);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name, boolean invalidate) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name, domain, path, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Set<Cookie> removeCookies(String name, boolean invalidate) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidateAll(name, invalidate);
        }
    }
}

