/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.examples.ctl;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.examples.ctl.Main;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="watch", description={"Watches events stream for a key"})
class CommandWatch
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandWatch.class);
    @CommandLine.ParentCommand
    Main main;
    @CommandLine.Parameters(arity="1", description={"<key>"})
    String key;
    @CommandLine.Option(names={"--rev"}, description={"Revision to start watching"}, defaultValue="0")
    Long rev;
    @CommandLine.Option(names={"-m", "--max-events"}, description={"the maximum number of events to receive"})
    Integer maxEvents;

    CommandWatch() {
    }

    @Override
    public void run() {
        CountDownLatch latch = new CountDownLatch(this.maxEvents != null ? this.maxEvents : Integer.MAX_VALUE);
        try (Client client = Client.builder().endpoints(this.main.endpoints).build();){
            ByteSequence watchKey = ByteSequence.from(this.key, StandardCharsets.UTF_8);
            WatchOption watchOpts = WatchOption.builder().withRevision(this.rev != null ? this.rev : 0L).build();
            Consumer<WatchResponse> consumer = response -> {
                for (WatchEvent event : response.getEvents()) {
                    LOGGER.info("type={}, key={}, value={}", event.getEventType().toString(), Optional.ofNullable(event.getKeyValue().getKey()).map(bs -> bs.toString(StandardCharsets.UTF_8)).orElse(""), Optional.ofNullable(event.getKeyValue().getValue()).map(bs -> bs.toString(StandardCharsets.UTF_8)).orElse(""));
                }
                latch.countDown();
            };
            Watch.Watcher ignored = client.getWatchClient().watch(watchKey, watchOpts, consumer);
            if (ignored != null) {
                ignored.close();
            }
            latch.await();
            LOGGER.info("done");
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }
}

