/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.examples.ctl;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.examples.ctl.Main;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="put", description={"Puts the given key into the store"})
class CommandPut
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandPut.class);
    @CommandLine.ParentCommand
    Main main;
    @CommandLine.Parameters(index="0", arity="1", description={"key"})
    String key;
    @CommandLine.Parameters(index="1", arity="1", description={"value"})
    String val;

    CommandPut() {
    }

    @Override
    public void run() {
        try (Client client = Client.builder().endpoints(this.main.endpoints).build();){
            client.getKVClient().put(ByteSequence.from(this.key, StandardCharsets.UTF_8), ByteSequence.from(this.val, StandardCharsets.UTF_8)).get();
            LOGGER.info("OK");
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }
}

