/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.examples.ctl;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.examples.ctl.Main;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Gets the key"})
class CommandGet
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandGet.class);
    @CommandLine.ParentCommand
    Main main;
    @CommandLine.Parameters(index="0", arity="1", description={"key"})
    String key;
    @CommandLine.Option(names={"--rev"}, description={"Revision to start watching"}, defaultValue="0")
    Long rev;

    CommandGet() {
    }

    @Override
    public void run() {
        try (Client client = Client.builder().endpoints(this.main.endpoints).build();){
            GetResponse getResponse = client.getKVClient().get(ByteSequence.from(this.key, StandardCharsets.UTF_8), GetOption.builder().withRevision(this.rev).build()).get();
            if (getResponse.getKvs().isEmpty()) {
                return;
            }
            LOGGER.info(this.key);
            LOGGER.info(getResponse.getKvs().get(0).getValue().toString(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }
}

