/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Election;
import io.etcd.jetcd.api.CampaignRequest;
import io.etcd.jetcd.api.LeaderRequest;
import io.etcd.jetcd.api.ProclaimRequest;
import io.etcd.jetcd.api.ResignRequest;
import io.etcd.jetcd.api.VertxElectionGrpc;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.election.CampaignResponse;
import io.etcd.jetcd.election.LeaderKey;
import io.etcd.jetcd.election.LeaderResponse;
import io.etcd.jetcd.election.NoLeaderException;
import io.etcd.jetcd.election.NotLeaderException;
import io.etcd.jetcd.election.ProclaimResponse;
import io.etcd.jetcd.election.ResignResponse;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.Impl;
import io.etcd.jetcd.support.Util;
import io.grpc.StatusRuntimeException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class ElectionImpl
extends Impl
implements Election {
    private final VertxElectionGrpc.ElectionVertxStub stub;
    private final ByteSequence namespace;

    ElectionImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxElectionGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<CampaignResponse> campaign(ByteSequence electionName, long leaseId, ByteSequence proposal) {
        Objects.requireNonNull(electionName, "election name should not be null");
        Objects.requireNonNull(proposal, "proposal should not be null");
        CampaignRequest request = CampaignRequest.newBuilder().setName(Util.prefixNamespace(electionName, this.namespace)).setValue(ByteString.copyFrom(proposal.getBytes())).setLease(leaseId).build();
        return this.completable(this.stub.campaign(request), CampaignResponse::new, this::convertException);
    }

    @Override
    public CompletableFuture<ProclaimResponse> proclaim(LeaderKey leaderKey, ByteSequence proposal) {
        Objects.requireNonNull(leaderKey, "leader key should not be null");
        Objects.requireNonNull(proposal, "proposal should not be null");
        ProclaimRequest request = ProclaimRequest.newBuilder().setLeader(io.etcd.jetcd.api.LeaderKey.newBuilder().setKey(ByteString.copyFrom(leaderKey.getKey().getBytes())).setName(ByteString.copyFrom(leaderKey.getName().getBytes())).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build()).setValue(ByteString.copyFrom(proposal.getBytes())).build();
        return this.completable(this.stub.proclaim(request), ProclaimResponse::new, this::convertException);
    }

    @Override
    public CompletableFuture<LeaderResponse> leader(ByteSequence electionName) {
        Objects.requireNonNull(electionName, "election name should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(Util.prefixNamespace(electionName, this.namespace)).build();
        return this.completable(this.stub.leader(request), r -> new LeaderResponse((io.etcd.jetcd.api.LeaderResponse)r, this.namespace), this::convertException);
    }

    @Override
    public void observe(ByteSequence electionName, Election.Listener listener) {
        Objects.requireNonNull(electionName, "election name should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(ByteString.copyFrom(electionName.getBytes())).build();
        this.stub.observe(request).handler(value -> listener.onNext(new LeaderResponse((io.etcd.jetcd.api.LeaderResponse)value, this.namespace))).endHandler(ignored -> listener.onCompleted()).exceptionHandler(error -> listener.onError(EtcdExceptionFactory.toEtcdException(error)));
    }

    @Override
    public CompletableFuture<ResignResponse> resign(LeaderKey leaderKey) {
        Objects.requireNonNull(leaderKey, "leader key should not be null");
        ResignRequest request = ResignRequest.newBuilder().setLeader(io.etcd.jetcd.api.LeaderKey.newBuilder().setKey(ByteString.copyFrom(leaderKey.getKey().getBytes())).setName(ByteString.copyFrom(leaderKey.getName().getBytes())).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build()).build();
        return this.completable(this.stub.resign(request), ResignResponse::new, this::convertException);
    }

    private Throwable convertException(Throwable e) {
        if (e instanceof StatusRuntimeException) {
            StatusRuntimeException exception = (StatusRuntimeException)e;
            String description = exception.getStatus().getDescription();
            if ("election: not leader".equals(description)) {
                return new NotLeaderException();
            }
            if ("election: no leader".equals(description)) {
                return new NoLeaderException();
            }
        }
        return EtcdExceptionFactory.toEtcdException(e);
    }
}

