/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.Maintenance;
import io.etcd.jetcd.api.AlarmRequest;
import io.etcd.jetcd.api.DefragmentRequest;
import io.etcd.jetcd.api.HashKVRequest;
import io.etcd.jetcd.api.MoveLeaderRequest;
import io.etcd.jetcd.api.SnapshotRequest;
import io.etcd.jetcd.api.SnapshotResponse;
import io.etcd.jetcd.api.StatusRequest;
import io.etcd.jetcd.api.VertxMaintenanceGrpc;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.Impl;
import io.etcd.jetcd.maintenance.AlarmMember;
import io.etcd.jetcd.maintenance.AlarmResponse;
import io.etcd.jetcd.maintenance.AlarmType;
import io.etcd.jetcd.maintenance.DefragmentResponse;
import io.etcd.jetcd.maintenance.HashKVResponse;
import io.etcd.jetcd.maintenance.MoveLeaderResponse;
import io.etcd.jetcd.maintenance.StatusResponse;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

final class MaintenanceImpl
extends Impl
implements Maintenance {
    private final VertxMaintenanceGrpc.MaintenanceVertxStub stub = this.connectionManager().newStub(VertxMaintenanceGrpc::newVertxStub);

    MaintenanceImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public CompletableFuture<AlarmResponse> listAlarms() {
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(io.etcd.jetcd.api.AlarmType.NONE).setAction(AlarmRequest.AlarmAction.GET).setMemberID(0L).build();
        return this.completable(this.stub.alarm(alarmRequest), AlarmResponse::new);
    }

    @Override
    public CompletableFuture<AlarmResponse> alarmDisarm(AlarmMember member) {
        Preconditions.checkArgument(member.getMemberId() != 0L, "the member id can not be 0");
        Preconditions.checkArgument(member.getAlarmType() != AlarmType.NONE, "alarm type can not be NONE");
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(io.etcd.jetcd.api.AlarmType.NOSPACE).setAction(AlarmRequest.AlarmAction.DEACTIVATE).setMemberID(member.getMemberId()).build();
        return this.completable(this.stub.alarm(alarmRequest), AlarmResponse::new);
    }

    @Override
    public CompletableFuture<DefragmentResponse> defragmentMember(URI endpoint) {
        return this.defragmentMember(endpoint.toString());
    }

    @Override
    public CompletableFuture<DefragmentResponse> defragmentMember(String target) {
        return this.connectionManager().withNewChannel(target, VertxMaintenanceGrpc::newVertxStub, stub -> stub.defragment(DefragmentRequest.getDefaultInstance()).map(DefragmentResponse::new).toCompletionStage().toCompletableFuture());
    }

    @Override
    public CompletableFuture<StatusResponse> statusMember(URI endpoint) {
        return this.statusMember(endpoint.toString());
    }

    @Override
    public CompletableFuture<StatusResponse> statusMember(String target) {
        return this.connectionManager().withNewChannel(target, VertxMaintenanceGrpc::newVertxStub, stub -> stub.status(StatusRequest.getDefaultInstance()).map(StatusResponse::new).toCompletionStage().toCompletableFuture());
    }

    @Override
    public CompletableFuture<MoveLeaderResponse> moveLeader(long transfereeID) {
        return this.completable(this.stub.moveLeader(MoveLeaderRequest.newBuilder().setTargetID(transfereeID).build()), MoveLeaderResponse::new);
    }

    @Override
    public CompletableFuture<HashKVResponse> hashKV(URI endpoint, long rev) {
        return this.hashKV(endpoint.toString(), rev);
    }

    @Override
    public CompletableFuture<HashKVResponse> hashKV(String target, long rev) {
        return this.connectionManager().withNewChannel(target, VertxMaintenanceGrpc::newVertxStub, stub -> stub.hashKV(HashKVRequest.newBuilder().setRevision(rev).build()).map(HashKVResponse::new).toCompletionStage().toCompletableFuture());
    }

    @Override
    public CompletableFuture<Long> snapshot(OutputStream outputStream) {
        CompletableFuture<Long> answer = new CompletableFuture<Long>();
        AtomicLong bytes = new AtomicLong(0L);
        this.stub.snapshot(SnapshotRequest.getDefaultInstance()).handler(r -> {
            try {
                r.getBlob().writeTo(outputStream);
                bytes.addAndGet(r.getBlob().size());
            }
            catch (IOException e) {
                answer.completeExceptionally(EtcdExceptionFactory.toEtcdException(e));
            }
        }).endHandler(event -> answer.complete(bytes.get())).exceptionHandler(e -> answer.completeExceptionally(EtcdExceptionFactory.toEtcdException(e)));
        return answer;
    }

    @Override
    public void snapshot(StreamObserver<io.etcd.jetcd.maintenance.SnapshotResponse> observer) {
        this.stub.snapshot(SnapshotRequest.getDefaultInstance()).handler(r -> observer.onNext(new io.etcd.jetcd.maintenance.SnapshotResponse((SnapshotResponse)r))).endHandler(event -> observer.onCompleted()).exceptionHandler(e -> observer.onError(EtcdExceptionFactory.toEtcdException(e)));
    }
}

