/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import java.nio.charset.StandardCharsets;

public final class URIDecoder {
    private URIDecoder() {
        throw new RuntimeException("Static Class");
    }

    public static String decodeURIComponent(String s2) {
        return URIDecoder.decodeURIComponent(s2, true);
    }

    public static String decodeURIComponent(String s2, boolean plus) {
        int i;
        if (s2 == null) {
            return null;
        }
        int size = s2.length();
        boolean modified = false;
        for (i = 0; i < size; ++i) {
            char c = s2.charAt(i);
            if (c != '%' && (!plus || c != '+')) continue;
            modified = true;
            break;
        }
        if (!modified) {
            return s2;
        }
        byte[] buf = s2.getBytes(StandardCharsets.UTF_8);
        int pos = i;
        while (i < size) {
            int c = s2.charAt(i);
            if (c == 37) {
                if (i == size - 1) {
                    throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s2);
                }
                if ((c = (int)s2.charAt(++i)) == 37) {
                    buf[pos++] = 37;
                    break;
                }
                if (i >= size - 1) {
                    throw new IllegalArgumentException("partial escape sequence at end of string: " + s2);
                }
                c = URIDecoder.decodeHexNibble((char)c);
                char c2 = URIDecoder.decodeHexNibble(s2.charAt(++i));
                if (c == 65535 || c2 == '\uffff') {
                    throw new IllegalArgumentException("invalid escape sequence `%" + s2.charAt(i - 1) + s2.charAt(i) + "' at index " + (i - 2) + " of: " + s2);
                }
                c = (char)(c * 16 + c2);
                buf[pos++] = (byte)c;
            } else {
                buf[pos++] = (byte)(plus && c == 43 ? 32 : c);
            }
            ++i;
        }
        return new String(buf, 0, pos, StandardCharsets.UTF_8);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

