/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.op;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.api.RequestOp;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.support.Requests;

public abstract class Op {
    protected final Type type;
    protected final ByteString key;

    protected Op(Type type, ByteString key) {
        this.type = type;
        this.key = key;
    }

    abstract RequestOp toRequestOp(ByteSequence var1);

    public static PutOp put(ByteSequence key, ByteSequence value, PutOption option) {
        return new PutOp(ByteString.copyFrom(key.getBytes()), ByteString.copyFrom(value.getBytes()), option);
    }

    public static GetOp get(ByteSequence key, GetOption option) {
        return new GetOp(ByteString.copyFrom(key.getBytes()), option);
    }

    public static DeleteOp delete(ByteSequence key, DeleteOption option) {
        return new DeleteOp(ByteString.copyFrom(key.getBytes()), option);
    }

    public static TxnOp txn(Cmp[] cmps, Op[] thenOps, Op[] elseOps) {
        return new TxnOp(cmps, thenOps, elseOps);
    }

    public static final class TxnOp
    extends Op {
        private final Cmp[] cmps;
        private final Op[] thenOps;
        private final Op[] elseOps;

        private TxnOp(Cmp[] cmps, Op[] thenOps, Op[] elseOps) {
            super(Type.TXN, null);
            this.cmps = cmps;
            this.thenOps = thenOps;
            this.elseOps = elseOps;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            TxnRequest.Builder txn = TxnRequest.newBuilder();
            if (this.cmps != null) {
                for (Cmp cmp : this.cmps) {
                    txn.addCompare(cmp.toCompare(namespace));
                }
            }
            if (this.thenOps != null) {
                for (Op thenOp : this.thenOps) {
                    txn.addSuccess(thenOp.toRequestOp(namespace));
                }
            }
            if (this.elseOps != null) {
                for (Op elseOp : this.elseOps) {
                    txn.addFailure(elseOp.toRequestOp(namespace));
                }
            }
            return RequestOp.newBuilder().setRequestTxn(txn).build();
        }
    }

    public static final class DeleteOp
    extends Op {
        private final DeleteOption option;

        DeleteOp(ByteString key, DeleteOption option) {
            super(Type.DELETE_RANGE, key);
            this.option = option;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            return RequestOp.newBuilder().setRequestDeleteRange(Requests.mapDeleteRequest(ByteSequence.from(this.key), this.option, namespace)).build();
        }
    }

    public static final class GetOp
    extends Op {
        private final GetOption option;

        private GetOp(ByteString key, GetOption option) {
            super(Type.RANGE, key);
            this.option = option;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            return RequestOp.newBuilder().setRequestRange(Requests.mapRangeRequest(ByteSequence.from(this.key), this.option, namespace)).build();
        }
    }

    public static final class PutOp
    extends Op {
        private final ByteString value;
        private final PutOption option;

        private PutOp(ByteString key, ByteString value, PutOption option) {
            super(Type.PUT, key);
            this.value = value;
            this.option = option;
        }

        @Override
        RequestOp toRequestOp(ByteSequence namespace) {
            return RequestOp.newBuilder().setRequestPut(Requests.mapPutRequest(ByteSequence.from(this.key), ByteSequence.from(this.value), this.option, namespace)).build();
        }
    }

    public static enum Type {
        PUT,
        RANGE,
        DELETE_RANGE,
        TXN;

    }
}

