/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Constants;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Util {
    static final String NO_LEADER_ERROR_MESSAGE = "etcdserver: no leader";

    private Util() {
    }

    public static List<URI> toURIs(Collection<String> uris) {
        return uris.stream().map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid endpoint URI: " + uri, e);
            }
        }).collect(Collectors.toList());
    }

    static <S, T> CompletableFuture<T> toCompletableFuture(final ListenableFuture<S> sourceFuture, Function<S, T> resultConvert, Executor executor) {
        CompletableFuture targetFuture = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                super.cancel(mayInterruptIfRunning);
                return sourceFuture.cancel(mayInterruptIfRunning);
            }
        };
        sourceFuture.addListener(() -> {
            try {
                targetFuture.complete(resultConvert.apply(sourceFuture.get()));
            }
            catch (Exception e) {
                targetFuture.completeExceptionally(EtcdExceptionFactory.toEtcdException(e));
            }
        }, executor);
        return targetFuture;
    }

    public static boolean isRetryable(Throwable e) {
        Status status = Status.fromThrowable(e);
        return Status.UNAVAILABLE.getCode().equals((Object)status.getCode()) || Util.isInvalidTokenError(status);
    }

    public static boolean isInvalidTokenError(Status status) {
        return status.getCode() == Status.Code.UNAUTHENTICATED && "etcdserver: invalid auth token".equals(status.getDescription());
    }

    public static <T> T supplyIfNull(T target, Supplier<T> supplier) {
        return target != null ? target : supplier.get();
    }

    public static ByteString prefixNamespace(ByteString key, ByteSequence namespace) {
        return namespace.isEmpty() ? key : namespace.getByteString().concat(key);
    }

    public static ByteString prefixNamespaceToRangeEnd(ByteString end, ByteSequence namespace) {
        if (namespace.isEmpty()) {
            return end;
        }
        if (end.size() == 1 && end.toByteArray()[0] == 0) {
            byte[] prefixedEndArray = namespace.getByteString().toByteArray();
            boolean ok = false;
            for (int i = prefixedEndArray.length - 1; i >= 0; --i) {
                prefixedEndArray[i] = (byte)(prefixedEndArray[i] + 1);
                if (prefixedEndArray[i] == 0) continue;
                ok = true;
                break;
            }
            if (!ok) {
                prefixedEndArray = new byte[]{0};
            }
            return ByteString.copyFrom(prefixedEndArray);
        }
        return namespace.getByteString().concat(end);
    }

    public static ByteString unprefixNamespace(ByteString key, ByteSequence namespace) {
        return namespace.isEmpty() ? key : key.substring(namespace.size());
    }

    static <T extends AbstractStub<T>> T applyRequireLeader(boolean requireLeader, T stub) {
        if (!requireLeader) {
            return stub;
        }
        Metadata md = new Metadata();
        md.put(Constants.REQUIRE_LEADER_KEY, "true");
        return stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(md));
    }

    public static boolean isHaltError(Status status) {
        return status.getCode() != Status.Code.UNAVAILABLE && status.getCode() != Status.Code.INTERNAL;
    }

    public static boolean isNoLeaderError(Status status) {
        return status.getCode() == Status.Code.UNAVAILABLE && NO_LEADER_ERROR_MESSAGE.equals(status.getDescription());
    }
}

