/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.Election;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.CampaignRequest;
import io.etcd.jetcd.api.CampaignResponse;
import io.etcd.jetcd.api.ElectionGrpc;
import io.etcd.jetcd.api.LeaderRequest;
import io.etcd.jetcd.api.ProclaimRequest;
import io.etcd.jetcd.api.ResignRequest;
import io.etcd.jetcd.api.ResignResponse;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.election.LeaderKey;
import io.etcd.jetcd.election.LeaderResponse;
import io.etcd.jetcd.election.NoLeaderException;
import io.etcd.jetcd.election.NotLeaderException;
import io.etcd.jetcd.election.ProclaimResponse;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

final class ElectionImpl
implements Election {
    private final ElectionGrpc.ElectionStub stub;
    private final ByteSequence namespace;

    ElectionImpl(ClientConnectionManager connectionManager) {
        this.stub = connectionManager.newStub(ElectionGrpc::newStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<io.etcd.jetcd.election.CampaignResponse> campaign(ByteSequence electionName, long leaseId, ByteSequence proposal) {
        Preconditions.checkNotNull(electionName, "election name should not be null");
        Preconditions.checkNotNull(proposal, "proposal should not be null");
        CampaignRequest request = CampaignRequest.newBuilder().setName(Util.prefixNamespace(electionName.getByteString(), this.namespace)).setValue(proposal.getByteString()).setLease(leaseId).build();
        StreamObserverDelegate<CampaignResponse, io.etcd.jetcd.election.CampaignResponse> observer = new StreamObserverDelegate<CampaignResponse, io.etcd.jetcd.election.CampaignResponse>(io.etcd.jetcd.election.CampaignResponse::new);
        this.stub.campaign(request, observer);
        return observer.getFuture();
    }

    @Override
    public CompletableFuture<ProclaimResponse> proclaim(LeaderKey leaderKey, ByteSequence proposal) {
        Preconditions.checkNotNull(leaderKey, "leader key should not be null");
        Preconditions.checkNotNull(proposal, "proposal should not be null");
        io.etcd.jetcd.api.LeaderKey leader = io.etcd.jetcd.api.LeaderKey.newBuilder().setKey(leaderKey.getKey()).setName(leaderKey.getName()).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build();
        ProclaimRequest request = ProclaimRequest.newBuilder().setLeader(leader).setValue(proposal.getByteString()).build();
        StreamObserverDelegate<io.etcd.jetcd.api.ProclaimResponse, ProclaimResponse> observer = new StreamObserverDelegate<io.etcd.jetcd.api.ProclaimResponse, ProclaimResponse>(ProclaimResponse::new);
        this.stub.proclaim(request, observer);
        return observer.getFuture();
    }

    @Override
    public CompletableFuture<LeaderResponse> leader(ByteSequence electionName) {
        Preconditions.checkNotNull(electionName, "election name should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(Util.prefixNamespace(electionName.getByteString(), this.namespace)).build();
        StreamObserverDelegate<io.etcd.jetcd.api.LeaderResponse, LeaderResponse> observer = new StreamObserverDelegate<io.etcd.jetcd.api.LeaderResponse, LeaderResponse>(input -> new LeaderResponse((io.etcd.jetcd.api.LeaderResponse)input, this.namespace));
        this.stub.leader(request, observer);
        return observer.getFuture();
    }

    @Override
    public void observe(ByteSequence electionName, final Election.Listener listener) {
        Preconditions.checkNotNull(electionName, "election name should not be null");
        Preconditions.checkNotNull(listener, "listener should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(electionName.getByteString()).build();
        this.stub.observe(request, new StreamObserver<io.etcd.jetcd.api.LeaderResponse>(){

            @Override
            public void onNext(io.etcd.jetcd.api.LeaderResponse value) {
                listener.onNext(new LeaderResponse(value, ElectionImpl.this.namespace));
            }

            @Override
            public void onError(Throwable error) {
                listener.onError(EtcdExceptionFactory.toEtcdException(error));
            }

            @Override
            public void onCompleted() {
                listener.onCompleted();
            }
        });
    }

    @Override
    public CompletableFuture<io.etcd.jetcd.election.ResignResponse> resign(LeaderKey leaderKey) {
        Preconditions.checkNotNull(leaderKey, "leader key should not be null");
        io.etcd.jetcd.api.LeaderKey leader = io.etcd.jetcd.api.LeaderKey.newBuilder().setKey(leaderKey.getKey()).setName(leaderKey.getName()).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build();
        ResignRequest request = ResignRequest.newBuilder().setLeader(leader).build();
        StreamObserverDelegate<ResignResponse, io.etcd.jetcd.election.ResignResponse> observer = new StreamObserverDelegate<ResignResponse, io.etcd.jetcd.election.ResignResponse>(io.etcd.jetcd.election.ResignResponse::new);
        this.stub.resign(request, observer);
        return observer.getFuture();
    }

    @Override
    public void close() {
    }

    private static class StreamObserverDelegate<S, T>
    implements StreamObserver<S> {
        private final CompletableFuture<T> future = new CompletableFuture();
        private final Function<S, T> converter;

        public StreamObserverDelegate(Function<S, T> converter) {
            this.converter = converter;
        }

        @Override
        public void onNext(S value) {
            this.future.complete(this.converter.apply(value));
        }

        @Override
        public void onError(Throwable error) {
            if (error instanceof StatusRuntimeException) {
                StatusRuntimeException exception = (StatusRuntimeException)error;
                String description = exception.getStatus().getDescription();
                if ("election: not leader".equals(description)) {
                    this.future.completeExceptionally(NotLeaderException.INSTANCE);
                } else if ("election: no leader".equals(description)) {
                    this.future.completeExceptionally(NoLeaderException.INSTANCE);
                }
            }
            this.future.completeExceptionally(EtcdExceptionFactory.toEtcdException(error));
        }

        @Override
        public void onCompleted() {
        }

        public CompletableFuture<T> getFuture() {
            return this.future;
        }
    }
}

