/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.examples.ctl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Charsets;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(separators="=", commandDescription="Gets the key")
class CommandGet
implements CheckedConsumer<Client> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandGet.class);
    @Parameter(arity=1, description="<key>")
    String key = "";
    @Parameter(names={"--rev"}, description="Specify the kv revision")
    Long rev = 0L;

    CommandGet() {
    }

    @Override
    public void accept(Client client) throws Exception {
        GetResponse getResponse = client.getKVClient().get(ByteSequence.from(this.key, Charsets.UTF_8), GetOption.newBuilder().withRevision(this.rev).build()).get();
        if (getResponse.getKvs().isEmpty()) {
            return;
        }
        LOGGER.info(this.key);
        LOGGER.info(getResponse.getKvs().get(0).getValue().toString(Charsets.UTF_8));
    }
}

