/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.lock.LockGrpc;
import io.etcd.jetcd.api.lock.LockRequest;
import io.etcd.jetcd.api.lock.UnlockRequest;
import io.etcd.jetcd.lock.LockResponse;
import io.etcd.jetcd.lock.UnlockResponse;
import java.util.concurrent.CompletableFuture;

final class LockImpl
implements Lock {
    private final ClientConnectionManager connectionManager;
    private final LockGrpc.LockFutureStub stub;
    private final ByteSequence namespace;

    LockImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(LockGrpc::newFutureStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<LockResponse> lock(ByteSequence name, long leaseId) {
        Preconditions.checkNotNull(name);
        LockRequest request = LockRequest.newBuilder().setName(Util.prefixNamespace(name.getByteString(), this.namespace)).setLease(leaseId).build();
        return this.connectionManager.execute(() -> this.stub.lock(request), response -> new LockResponse((io.etcd.jetcd.api.lock.LockResponse)response, this.namespace), Util::isRetryable);
    }

    @Override
    public CompletableFuture<UnlockResponse> unlock(ByteSequence lockKey) {
        Preconditions.checkNotNull(lockKey);
        UnlockRequest request = UnlockRequest.newBuilder().setKey(Util.prefixNamespace(lockKey.getByteString(), this.namespace)).build();
        return this.connectionManager.execute(() -> this.stub.unlock(request), UnlockResponse::new, Util::isRetryable);
    }
}

