/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.support.CloseableClient;
import io.etcd.jetcd.watch.WatchResponse;
import java.io.Closeable;
import java.util.function.Consumer;

public interface Watch
extends CloseableClient {
    public Watcher watch(ByteSequence var1, WatchOption var2, Listener var3);

    default public Watcher watch(ByteSequence key, Listener listener) {
        return this.watch(key, WatchOption.DEFAULT, listener);
    }

    default public Watcher watch(ByteSequence key, Consumer<WatchResponse> onNext) {
        return this.watch(key, WatchOption.DEFAULT, Watch.listener(onNext));
    }

    default public Watcher watch(ByteSequence key, Consumer<WatchResponse> onNext, Consumer<Throwable> onError) {
        return this.watch(key, WatchOption.DEFAULT, Watch.listener(onNext, onError));
    }

    default public Watcher watch(ByteSequence key, Consumer<WatchResponse> onNext, Consumer<Throwable> onError, Runnable onCompleted) {
        return this.watch(key, WatchOption.DEFAULT, Watch.listener(onNext, onError, onCompleted));
    }

    default public Watcher watch(ByteSequence key, Consumer<WatchResponse> onNext, Runnable onCompleted) {
        return this.watch(key, WatchOption.DEFAULT, Watch.listener(onNext, t -> {}, onCompleted));
    }

    default public Watcher watch(ByteSequence key, WatchOption option, Consumer<WatchResponse> onNext) {
        return this.watch(key, option, Watch.listener(onNext));
    }

    default public Watcher watch(ByteSequence key, WatchOption option, Consumer<WatchResponse> onNext, Consumer<Throwable> onError) {
        return this.watch(key, option, Watch.listener(onNext, onError));
    }

    default public Watcher watch(ByteSequence key, WatchOption option, Consumer<WatchResponse> onNext, Runnable onCompleted) {
        return this.watch(key, option, Watch.listener(onNext, t -> {}, onCompleted));
    }

    default public Watcher watch(ByteSequence key, WatchOption option, Consumer<WatchResponse> onNext, Consumer<Throwable> onError, Runnable onCompleted) {
        return this.watch(key, option, Watch.listener(onNext, onError, onCompleted));
    }

    public void requestProgress();

    public static Listener listener(Consumer<WatchResponse> onNext) {
        return Watch.listener(onNext, t -> {}, () -> {});
    }

    public static Listener listener(Consumer<WatchResponse> onNext, Consumer<Throwable> onError) {
        return Watch.listener(onNext, onError, () -> {});
    }

    public static Listener listener(Consumer<WatchResponse> onNext, Runnable onCompleted) {
        return Watch.listener(onNext, t -> {}, onCompleted);
    }

    public static Listener listener(final Consumer<WatchResponse> onNext, final Consumer<Throwable> onError, final Runnable onCompleted) {
        return new Listener(){

            @Override
            public void onNext(WatchResponse response) {
                onNext.accept(response);
            }

            @Override
            public void onError(Throwable throwable) {
                onError.accept(throwable);
            }

            @Override
            public void onCompleted() {
                onCompleted.run();
            }
        };
    }

    public static interface Listener {
        public void onNext(WatchResponse var1);

        public void onError(Throwable var1);

        public void onCompleted();
    }

    public static interface Watcher
    extends Closeable {
        @Override
        public void close();

        public boolean isClosed();

        public void requestProgress();
    }
}

