/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.container;

import io.ebean.docker.container.ContainerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoStart {
    private static Logger log = LoggerFactory.getLogger(AutoStart.class);

    public static void run() {
        new AutoStart().run(AutoStart.loadProps());
    }

    public static void stop() {
        new AutoStart().stop(AutoStart.loadProps());
    }

    private static Properties loadProps() {
        Properties properties = new Properties();
        try (InputStream is = AutoStart.class.getResourceAsStream("/docker-run.properties");){
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException e) {
            log.warn("failed to load docker-run.properties file", (Throwable)e);
        }
        return properties;
    }

    private void run(Properties properties) {
        new ContainerFactory(properties).startContainers();
    }

    private void stop(Properties properties) {
        new ContainerFactory(properties).stopContainers();
    }
}

