/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands.process;

import io.ebean.docker.commands.CommandException;
import io.ebean.docker.commands.process.ProcessResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessHandler.class);
    private final ProcessBuilder builder;
    private Process process;
    private List<String> out = new ArrayList<String>();
    private String match;
    private String clearMatch;

    private ProcessHandler(ProcessBuilder builder, String match, String clearMatch) {
        this.builder = builder;
        this.match = match;
        this.clearMatch = clearMatch;
    }

    public static ProcessResult matchCommand(String match, String clearMatch, String ... command) {
        return ProcessHandler.process(new ProcessBuilder(command), match, clearMatch);
    }

    public static ProcessResult command(String ... command) {
        return ProcessHandler.process(new ProcessBuilder(command));
    }

    public static ProcessResult command(List<String> commands) {
        return ProcessHandler.process(new ProcessBuilder(commands));
    }

    public static ProcessResult process(ProcessBuilder pb) {
        return ProcessHandler.process(pb, null, null);
    }

    private static ProcessResult process(ProcessBuilder pb, String match, String clearMatch) {
        try {
            ProcessHandler handler = new ProcessHandler(pb, match, clearMatch);
            handler.start();
            ProcessResult result = handler.read();
            if (!result.success()) {
                throw new CommandException("command failed: " + result.getOutLines(), result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void start() throws IOException {
        this.builder.redirectErrorStream(true);
        this.process = this.builder.start();
    }

    private ProcessResult read() {
        try {
            String s;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((s = stdInput.readLine()) != null) {
                this.processLine(s, this.out);
            }
            int result = this.process.waitFor();
            ProcessResult pr = new ProcessResult(result, this.out);
            if (!pr.success() && log.isTraceEnabled()) {
                log.trace(pr.debug());
            }
            return pr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processLine(String lineContent, List<String> lines) {
        if (this.clearMatch != null && lineContent.contains(this.clearMatch)) {
            this.out.clear();
        } else if (this.match != null) {
            if (lineContent.contains(this.match)) {
                this.out.add(lineContent);
            }
        } else {
            lines.add(lineContent);
        }
    }
}

