/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.BasePostgresContainer;

public class PostgisContainer
extends BasePostgresContainer<PostgisContainer> {
    @Override
    public PostgisContainer start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return PostgisContainer.builder(version);
    }

    private PostgisContainer(Builder config) {
        super(config);
    }

    public static class Builder
    extends BaseDbBuilder<PostgisContainer, Builder> {
        private Builder(String version) {
            super("postgis", 6432, 5432, version);
            this.image = "ghcr.io/baosystems/postgis:" + version;
            this.adminUsername = "postgres";
            this.tmpfs = "/var/lib/postgresql/data:rw";
            this.extraDbExtensions = this.extensions = "hstore,pgcrypto,postgis";
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.dbName;
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/postgres";
        }

        @Override
        protected String buildExtraJdbcUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.extraDb;
        }

        @Override
        public PostgisContainer build() {
            return new PostgisContainer(this);
        }

        @Override
        public PostgisContainer start() {
            return this.build().start();
        }
    }
}

