/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.Commands;
import io.ebean.test.containers.DbContainer;

abstract class BaseDbContainer<C extends BaseDbContainer<C>>
extends DbContainer<C> {
    protected static final System.Logger log = Commands.log;

    BaseDbContainer(BaseDbBuilder config) {
        super(config);
    }

    protected abstract void createDbPreConnectivity();

    protected abstract void dropCreateDbPreConnectivity();

    protected void createDbPostConnectivity() {
    }

    protected void dropCreateDbPostConnectivity() {
    }

    @Override
    public boolean startWithCreate() {
        if (this.startIfNeeded() && this.fastStart()) {
            this.createDbPostConnectivity();
            return true;
        }
        if (!this.waitForDatabaseReady()) {
            log.log(System.Logger.Level.WARNING, "Failed waitForDatabaseReady for container {0}", this.config.containerName());
            return false;
        }
        this.createDbPreConnectivity();
        if (!this.waitForConnectivity()) {
            log.log(System.Logger.Level.WARNING, "Failed waiting for connectivity");
            return false;
        }
        this.createDbPostConnectivity();
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.log(System.Logger.Level.WARNING, "Failed waitForDatabaseReady for container {0}", this.config.containerName());
            return false;
        }
        this.dropCreateDbPreConnectivity();
        if (!this.waitForConnectivity()) {
            log.log(System.Logger.Level.WARNING, "Failed waiting for connectivity");
            return false;
        }
        this.dropCreateDbPostConnectivity();
        return true;
    }
}

