/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.Commands;
import io.ebean.test.containers.ContainerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AutoStart {
    public static void run() {
        new AutoStart().run(AutoStart.loadProps());
    }

    public static void stop() {
        new AutoStart().stop(AutoStart.loadProps());
    }

    private static Properties loadProps() {
        Properties properties = new Properties();
        try (InputStream is = AutoStart.class.getResourceAsStream("/docker-run.properties");){
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException e) {
            Commands.log.log(System.Logger.Level.WARNING, "failed to load docker-run.properties file", (Throwable)e);
        }
        return properties;
    }

    private void run(Properties properties) {
        new ContainerFactory(properties).startContainers();
    }

    private void stop(Properties properties) {
        new ContainerFactory(properties).stopContainers();
    }
}

