/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationConfig;
import io.ebean.migration.util.JdbcClose;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationSchema {
    private static final Logger logger = LoggerFactory.getLogger(MigrationSchema.class);
    private final Connection connection;
    private final String dbSchema;
    private final boolean createSchemaIfNotExists;

    public MigrationSchema(MigrationConfig migrationConfig, Connection connection) {
        this.dbSchema = this.trim(migrationConfig.getDbSchema());
        this.createSchemaIfNotExists = migrationConfig.isCreateSchemaIfNotExists();
        this.connection = connection;
    }

    private String trim(String dbSchema) {
        return dbSchema == null ? null : dbSchema.trim();
    }

    public void createAndSetIfNeeded() throws SQLException {
        if (this.dbSchema != null) {
            logger.info("Migration Schema: {}", (Object)this.dbSchema);
            if (this.createSchemaIfNotExists) {
                this.createSchemaIfNeeded();
            }
            this.setSchema();
        }
    }

    private void createSchemaIfNeeded() throws SQLException {
        if (!this.schemaExists()) {
            logger.info("Creating Schema: {}", (Object)this.dbSchema);
            Statement query = this.connection.createStatement();
            try {
                query.executeUpdate("CREATE SCHEMA " + this.dbSchema);
            }
            finally {
                JdbcClose.close(query);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schemaExists() throws SQLException {
        ResultSet schemas = this.connection.getMetaData().getSchemas();
        try {
            while (schemas.next()) {
                String schema = schemas.getString(1);
                if (!schema.equalsIgnoreCase(this.dbSchema)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            JdbcClose.close(schemas);
        }
        return false;
    }

    private void setSchema() throws SQLException {
        logger.info("Setting Schema: {}", (Object)this.dbSchema);
        this.connection.setSchema(this.dbSchema);
    }
}

