/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationVersion;
import io.ebean.migration.runner.LocalMigrationResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.avaje.classpath.scanner.Resource;
import org.avaje.classpath.scanner.ResourceFilter;
import org.avaje.classpath.scanner.core.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMigrationResources {
    private static final Logger logger = LoggerFactory.getLogger(LocalMigrationResources.class);
    private final MigrationConfig migrationConfig;
    private final List<LocalMigrationResource> versions = new ArrayList<LocalMigrationResource>();

    public LocalMigrationResources(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    public boolean readResources() {
        String migrationPath = this.migrationConfig.getMigrationPath();
        ClassLoader classLoader = this.migrationConfig.getClassLoader();
        Scanner scanner = new Scanner(classLoader);
        List resourceList = scanner.scanForResources(migrationPath, (ResourceFilter)new Match(this.migrationConfig));
        logger.debug("resources: {}", (Object)resourceList);
        for (Resource resource : resourceList) {
            String filename = resource.getFilename();
            if (!filename.endsWith(this.migrationConfig.getApplySuffix())) continue;
            int pos = filename.lastIndexOf(this.migrationConfig.getApplySuffix());
            String mainName = filename.substring(0, pos);
            MigrationVersion migrationVersion = MigrationVersion.parse(mainName);
            LocalMigrationResource res = new LocalMigrationResource(migrationVersion, resource.getLocation(), resource);
            this.versions.add(res);
        }
        Collections.sort(this.versions);
        return !this.versions.isEmpty();
    }

    public List<LocalMigrationResource> getVersions() {
        return this.versions;
    }

    private static class Match
    implements ResourceFilter {
        private final MigrationConfig migrationConfig;

        Match(MigrationConfig migrationConfig) {
            this.migrationConfig = migrationConfig;
        }

        public boolean isMatch(String name) {
            return name.endsWith(this.migrationConfig.getApplySuffix());
        }
    }
}

