/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationVersion;
import org.avaje.classpath.scanner.Resource;

public class LocalMigrationResource
implements Comparable<LocalMigrationResource> {
    private static final String REPEAT_TYPE = "R";
    private static final String VERSION_TYPE = "V";
    private final MigrationVersion version;
    private final String location;
    private final Resource resource;

    public LocalMigrationResource(MigrationVersion version, String location, Resource resource) {
        this.version = version;
        this.location = location;
        this.resource = resource;
    }

    public String toString() {
        return this.version.toString();
    }

    public boolean isRepeatable() {
        return this.version.isRepeatable();
    }

    public String key() {
        if (this.isRepeatable()) {
            return this.version.getComment().toLowerCase();
        }
        return this.version.normalised();
    }

    public String getComment() {
        String comment = this.version.getComment();
        return comment == null || comment.isEmpty() ? "-" : comment;
    }

    @Override
    public int compareTo(LocalMigrationResource o) {
        return this.version.compareTo(o.version);
    }

    public MigrationVersion getVersion() {
        return this.version;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContent() {
        return this.resource.loadAsString("UTF-8");
    }

    public String getType() {
        return this.isRepeatable() ? REPEAT_TYPE : VERSION_TYPE;
    }
}

