/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.ebean.migration.DbPlatformNames;
import java.sql.Connection;
import java.sql.SQLException;

class DbNameUtil
implements DbPlatformNames {
    DbNameUtil() {
    }

    static String normalise(Connection connection) {
        try {
            String productName = connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (productName.contains("postgres")) {
                return "postgres";
            }
            if (productName.contains("mysql")) {
                return "mysql";
            }
            if (productName.contains("oracle")) {
                return "oracle";
            }
            if (productName.contains("microsoft")) {
                return "sqlserver";
            }
            if (productName.contains("db2")) {
                return "db2";
            }
            if (productName.contains("h2")) {
                return "h2";
            }
            if (productName.contains("hsql")) {
                return "hsql";
            }
            if (productName.contains("sqlite")) {
                return "sqlite";
            }
            if (productName.contains("sql anywhere")) {
                return "sqlanywhere";
            }
            return "";
        }
        catch (SQLException e) {
            return "";
        }
    }
}

