/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.DataSourceBuilder;
import io.ebean.datasource.pool.Log;
import io.ebean.datasource.pool.ObtainDriver;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.DataSource;

final class DriverDataSource
implements DataSource {
    private final String name;
    private final Driver driver;
    private final String url;
    private final Properties connectionProps;
    private final String password2;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean fixedCredentials;

    DriverDataSource(String name, Driver driver, String url, Properties properties, String password2) {
        this.name = name;
        this.driver = driver;
        this.url = url;
        this.connectionProps = properties;
        this.password2 = password2;
        this.fixedCredentials = password2 == null;
    }

    static DataSource of(String name, DataSourceBuilder.Settings builder) {
        DataSource dataSource = builder.dataSource();
        if (dataSource != null) {
            return dataSource;
        }
        Properties connectionProps = builder.connectionProperties();
        Driver driver = ObtainDriver.driver(builder, builder.getUrl());
        return new DriverDataSource(name, driver, builder.getUrl(), connectionProps, builder.getPassword2());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties(this.connectionProps);
        props.setProperty("user", username);
        props.setProperty("password", password);
        return this.driver.connect(this.url, props);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.driver.connect(this.url, this.connectionProps);
        }
        catch (SQLException e) {
            this.lock.lock();
            try {
                if (this.fixedCredentials) {
                    throw e;
                }
                Log.debug("DataSource [{0}] trying alternate credentials due to {1}", this.name, e.getMessage());
                Connection connection = this.switchCredentials(this.connectionProps);
                return connection;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private Connection switchCredentials(Properties properties) throws SQLException {
        Properties copy = new Properties(properties);
        copy.setProperty("password", this.password2);
        Connection connection = this.driver.connect(this.url, copy);
        Log.info("DataSource [{0}] now using alternate credentials", this.name);
        this.fixedCredentials = true;
        properties.setProperty("password", this.password2);
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        throw new UnsupportedOperationException();
    }
}

