/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.pool.PooledConnection;
import io.ebean.datasource.pool.PooledConnectionStatistics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FreeConnectionBuffer {
    private static final Logger logger = LoggerFactory.getLogger(FreeConnectionBuffer.class);
    private final LinkedList<PooledConnection> freeBuffer = new LinkedList();

    FreeConnectionBuffer() {
    }

    int size() {
        return this.freeBuffer.size();
    }

    boolean isEmpty() {
        return this.freeBuffer.isEmpty();
    }

    void add(PooledConnection pc) {
        this.freeBuffer.addFirst(pc);
    }

    PooledConnection remove() {
        return this.freeBuffer.removeFirst();
    }

    void closeAll(boolean logErrors) {
        ArrayList<PooledConnection> tempList = new ArrayList<PooledConnection>(this.freeBuffer.size());
        tempList.addAll(this.freeBuffer);
        this.freeBuffer.clear();
        logger.debug("... closing all {} connections from the free list with logErrors: {}", (Object)tempList.size(), (Object)logErrors);
        for (int i = 0; i < tempList.size(); ++i) {
            PooledConnection pooledConnection = (PooledConnection)tempList.get(i);
            logger.debug("... closing {} of {} connections from the free list", (Object)i, (Object)tempList.size());
            pooledConnection.closeConnectionFully(logErrors);
        }
    }

    int trim(long usedSince, long createdSince) {
        int trimCount = 0;
        Iterator iterator = this.freeBuffer.iterator();
        while (iterator.hasNext()) {
            PooledConnection pooledConnection = (PooledConnection)iterator.next();
            if (!pooledConnection.shouldTrim(usedSince, createdSince)) continue;
            iterator.remove();
            pooledConnection.closeConnectionFully(true);
            ++trimCount;
        }
        return trimCount;
    }

    void collectStatistics(PooledConnectionStatistics.LoadValues values, boolean reset) {
        for (PooledConnection c : this.freeBuffer) {
            values.plus(c.getStatistics().getValues(reset));
        }
    }
}

