/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.spatial.search.Bound;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.incremental.SpatialDimensionRowTransformer;

public class SpatialFilter
implements Filter {
    private final String dimension;
    private final Bound bound;

    public SpatialFilter(String dimension, Bound bound) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.bound = (Bound)Preconditions.checkNotNull((Object)bound, (Object)"bound");
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        Iterable search = selector.getSpatialIndex(this.dimension).search(this.bound);
        return selector.getBitmapFactory().union(search);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, new Predicate(){

            public boolean apply(Object input) {
                if (input instanceof String) {
                    float[] coordinate = SpatialDimensionRowTransformer.decode((String)input);
                    return SpatialFilter.this.bound.contains(coordinate);
                }
                return false;
            }
        });
    }
}

