/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.filter.Filters;

public class DimensionPredicateFilter
implements Filter {
    private final String dimension;
    private final Predicate<String> predicate;

    public DimensionPredicateFilter(String dimension, final Predicate<String> predicate, final ExtractionFn extractionFn) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.predicate = extractionFn == null ? predicate : new Predicate<String>(){

            public boolean apply(String input) {
                return predicate.apply((Object)extractionFn.apply(input));
            }
        };
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        return Filters.matchPredicate(this.dimension, selector, this.predicate);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicate);
    }
}

