/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Predicate;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.query.ordering.StringComparators;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.filter.Filters;
import java.util.Comparator;
import java.util.Iterator;

public class BoundFilter
implements Filter {
    private final BoundDimFilter boundDimFilter;
    private final Comparator<String> comparator;
    private final ExtractionFn extractionFn;

    public BoundFilter(BoundDimFilter boundDimFilter) {
        this.boundDimFilter = boundDimFilter;
        this.comparator = boundDimFilter.isAlphaNumeric() ? StringComparators.ALPHANUMERIC : StringComparators.LEXICOGRAPHIC;
        this.extractionFn = boundDimFilter.getExtractionFn();
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        int found;
        if (this.boundDimFilter.isAlphaNumeric() || this.extractionFn != null) {
            return Filters.matchPredicate(this.boundDimFilter.getDimension(), selector, new Predicate<String>(){

                public boolean apply(String input) {
                    return BoundFilter.this.doesMatch(input);
                }
            });
        }
        final BitmapIndex bitmapIndex = selector.getBitmapIndex(this.boundDimFilter.getDimension());
        if (bitmapIndex == null || bitmapIndex.getCardinality() == 0) {
            if (this.doesMatch(null)) {
                return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
            }
            return selector.getBitmapFactory().makeEmptyImmutableBitmap();
        }
        final int startIndex = !this.boundDimFilter.hasLowerBound() ? 0 : ((found = bitmapIndex.getIndex(this.boundDimFilter.getLower())) >= 0 ? (this.boundDimFilter.isLowerStrict() ? found + 1 : found) : -(found + 1));
        final int endIndex = !this.boundDimFilter.hasUpperBound() ? bitmapIndex.getCardinality() : ((found = bitmapIndex.getIndex(this.boundDimFilter.getUpper())) >= 0 ? (this.boundDimFilter.isUpperStrict() ? found : found + 1) : -(found + 1));
        return selector.getBitmapFactory().union((Iterable)new Iterable<ImmutableBitmap>(){

            @Override
            public Iterator<ImmutableBitmap> iterator() {
                return new Iterator<ImmutableBitmap>(){
                    int currIndex;
                    {
                        this.currIndex = startIndex;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currIndex < endIndex;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return bitmapIndex.getBitmap(this.currIndex++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.boundDimFilter.getDimension(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return BoundFilter.this.doesMatch(input);
            }
        });
    }

    private boolean doesMatch(String input) {
        if (this.extractionFn != null) {
            input = this.extractionFn.apply(input);
        }
        if (input == null) {
            return (!this.boundDimFilter.hasLowerBound() || this.boundDimFilter.getLower().isEmpty() && !this.boundDimFilter.isLowerStrict()) && (!this.boundDimFilter.hasUpperBound() || !this.boundDimFilter.getUpper().isEmpty() || !this.boundDimFilter.isUpperStrict());
        }
        int lowerComparing = 1;
        int upperComparing = 1;
        if (this.boundDimFilter.hasLowerBound()) {
            lowerComparing = this.comparator.compare(input, this.boundDimFilter.getLower());
        }
        if (this.boundDimFilter.hasUpperBound()) {
            upperComparing = this.comparator.compare(this.boundDimFilter.getUpper(), input);
        }
        if (this.boundDimFilter.isLowerStrict() && this.boundDimFilter.isUpperStrict()) {
            return lowerComparing > 0 && upperComparing > 0;
        }
        if (this.boundDimFilter.isLowerStrict()) {
            return lowerComparing > 0 && upperComparing >= 0;
        }
        if (this.boundDimFilter.isUpperStrict()) {
            return lowerComparing >= 0 && upperComparing > 0;
        }
        return lowerComparing >= 0 && upperComparing >= 0;
    }
}

