/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Preconditions;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.common.io.smoosh.SmooshedFileMapper;
import io.druid.segment.Metadata;
import io.druid.segment.QueryableIndex;
import io.druid.segment.column.Column;
import io.druid.segment.data.Indexed;
import java.io.IOException;
import java.util.Map;
import org.joda.time.Interval;

public class SimpleQueryableIndex
implements QueryableIndex {
    private final Interval dataInterval;
    private final Indexed<String> columnNames;
    private final Indexed<String> availableDimensions;
    private final BitmapFactory bitmapFactory;
    private final Map<String, Column> columns;
    private final SmooshedFileMapper fileMapper;
    private final Metadata metadata;

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> columnNames, Indexed<String> dimNames, BitmapFactory bitmapFactory, Map<String, Column> columns, SmooshedFileMapper fileMapper, Metadata metadata) {
        Preconditions.checkNotNull((Object)columns.get("__time"));
        this.dataInterval = dataInterval;
        this.columnNames = columnNames;
        this.availableDimensions = dimNames;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.metadata = metadata;
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.columns.get("__time").getLength();
    }

    @Override
    public Indexed<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    @Override
    public BitmapFactory getBitmapFactoryForDimensions() {
        return this.bitmapFactory;
    }

    @Override
    public Column getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    @Override
    public void close() throws IOException {
        this.fileMapper.close();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }
}

